#include "photo.h"
#include "utils/utils.h"

Photo::Photo()
{
}

Photo::Photo(const Photo &src)
    : QObject(src.parent())
{
    Photo::copyData(this, &src);
}

void Photo::copyData(Photo *dst, const Photo *src)
{
    dst->accountId = src->accountId;
    dst->albumId = src->albumId;
    dst->ownerId = src->ownerId;
    dst->photoId = src->photoId;
    dst->photo_url = src->photo_url;
    dst->photo = src->photo;
    dst->icon_url = src->icon_url;
    dst->icon = src->icon;
    dst->time_create = src->time_create;
}

QDomElement Photo::toQDomElement(QDomDocument doc) {
    return Photo::toQDomElement(doc, *this);
}

QDomElement Photo::toQDomElement(QDomDocument doc, Photo src) {
    QDomElement ret = doc.createElement(NODE_PHOTO_ROOT);

    // ID
    QDomElement node = doc.createElement(NODE_PHOTO_ID);
    QDomText t = doc.createTextNode(src.photoId);
    ret.appendChild(node);
    node.appendChild(t);

    //time create
    node = doc.createElement(NODE_PHOTO_CREATE);
    t = doc.createTextNode(src.time_create);
    ret.appendChild(node);
    node.appendChild(t);

    //icon url
    node = doc.createElement(NODE_PHOTO_ICON_URL);
    t = doc.createTextNode(src.icon_url);
    ret.appendChild(node);
    node.appendChild(t);

    //icon
    node = doc.createElement(NODE_PHOTO_ICON);
    t = doc.createTextNode(src.icon);
    ret.appendChild(node);
    node.appendChild(t);

    //image url
    node = doc.createElement(NODE_PHOTO_IMAGE_URL);
    t = doc.createTextNode(src.photo_url);
    ret.appendChild(node);
    node.appendChild(t);

    //image
    node = doc.createElement(NODE_PHOTO_IMAGE);
    t = doc.createTextNode(src.photo);
    ret.appendChild(node);
    node.appendChild(t);


    return ret;
}

Photo Photo::fromQDomElement(QDomElement fr, QString accountId, QString friendId, QString albumId) {
    Photo ret = Photo();

    ret.photoId = fr.elementsByTagName(NODE_PHOTO_ID).at(0).firstChild().toText().data();
    ret.icon_url = fr.elementsByTagName(NODE_PHOTO_ICON_URL).at(0).firstChild().toText().data();
    ret.icon = fr.elementsByTagName(NODE_PHOTO_ICON).at(0).firstChild().toText().data();
    ret.time_create = fr.elementsByTagName(NODE_PHOTO_CREATE).at(0).firstChild().toText().data();
    ret.photo_url = fr.elementsByTagName(NODE_PHOTO_IMAGE_URL).at(0).firstChild().toText().data();
    ret.photo = fr.elementsByTagName(NODE_PHOTO_IMAGE).at(0).firstChild().toText().data();
    ret.accountId = accountId;
    ret.ownerId = friendId;
    ret.albumId = albumId;

    return ret;
}

Photo& Photo::operator =(Photo const& src)
{
    Photo::copyData(this, &src);

    return *this;
}

PhotoCommentList Photo::getPhotoComments()
{
    PhotoCommentList ret;
    QFile file(Utils::getAccountDir(this->accountId) + QString(FILE_PHOTO_COMMENTS_DATA).arg(this->ownerId, this->albumId, this->photoId));
    qDebug() << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): " << file.fileName();
    if (file.open(QIODevice::ReadOnly) == false)
        return ret;

    QDomDocument doc;
    doc.setContent(&file);
    file.close();

    QDomNodeList lst = doc.elementsByTagName(NODE_PHOTO_COMMENT_ROOT);

    qDebug() << "Start load of " << lst.length() << " comments for " << this->photoId;
    for (uint i = 0; i < lst.length(); i++) {
        ret.append(PhotoComment::fromQDomElement(lst.at(i).toElement(), this->accountId, this->ownerId, this->albumId, this->photoId));
    }

    qDebug() << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): loaded " << ret.length() << " comments";
    return ret;
}

void Photo::setPhotoComments(PhotoCommentList list, QString accountId, QString friendId, QString albumId, QString photoId)
{
    // store photo lists into cache
    QDomDocument out("MyDoc");
    QDomElement root = out.createElement(NODE_PHOTO_COMMENTS_ROOT);
    out.appendChild(root);

    for (int i = 0; i < list.length(); i++) {
        PhotoComment curPh = list.at(i);
        root.appendChild(PhotoComment::toQDomElement(out, curPh));
    }

    QDir dir;

    dir.setPath(dir.cleanPath(Utils::getAccountDir(accountId)));
    if (!dir.exists())
        dir.mkpath(dir.absolutePath());

    QFile file(dir.absolutePath() + "/" + QString(FILE_PHOTO_COMMENTS_DATA).arg(friendId, albumId, photoId));
    qDebug() << __FILE__ << ":" << __LINE__ << ": " << file.fileName();
    if (file.open(QIODevice::WriteOnly | QIODevice::Text | QIODevice::Truncate) == false) {
        qDebug() << "can't open file: " + file.errorString();
    }
    //file.write(output.toUtf8());
    file.write(out.toByteArray(1));
    file.close();
}
