#include "message.h"
#include <QRegExp>

#define SUBJECT_LENGTH 20
#define DEFAULT_SUBJECT "..."

Message::Message() :
    QObject(0)
{
}

Message::Message(const Message &src)
    : QObject(src.parent())
{
    Message::copyData(this, &src);
}

Message::~Message() {

}

void Message::copyData(Message *dst, const Message *src) {
    dst->messageId = src->messageId;
    dst->accountId = src->accountId;
    dst->senderId = src->senderId;
    dst->senderName = src->senderName;
//    dst->recepientId = src->recepientId;
//    dst->recepientName = src->recepientName;
    dst->text = src->text;
    dst->time = src->time;
    dst->title = src->title;
}

Message Message::fromQDomElement(QDomElement fr, QString accountId) {
    Message ret = Message();

    ret.accountId = accountId;

    ret.messageId = fr.elementsByTagName(NODE_MESSAGE_ID).at(0).firstChild().toText().data();
    ret.senderId = fr.elementsByTagName(NODE_MESSAGE_SENDER_ID).at(0).firstChild().toText().data();
    ret.senderName = fr.elementsByTagName(NODE_MESSAGE_SENDER_NAME).at(0).firstChild().toText().data();
//    ret.recepientId = fr.elementsByTagName(NODE_MESSAGE_RECEPIENT_ID).at(0).firstChild().toText().data();
//    ret.recepientName = fr.elementsByTagName(NODE_MESSAGE_RECEPIENT_NAME).at(0).firstChild().toText().data();
    ret.text = fr.elementsByTagName(NODE_MESSAGE_TEXT).at(0).firstChild().toText().data();
    ret.time = fr.elementsByTagName(NODE_MESSAGE_TIME).at(0).firstChild().toText().data();
    ret.title = fr.elementsByTagName(NODE_MESSAGE_TITLE).at(0).firstChild().toText().data();

    return ret;
}

QDomElement Message::toQDomElement(QDomDocument doc) {
    return Message::toQDomElement(doc, *this);
}

QDomElement Message::toQDomElement(QDomDocument doc, Message src) {
    QDomElement ret = doc.createElement(NODE_MESSAGE_ROOT);

    // ID
    QDomElement node = doc.createElement(NODE_MESSAGE_ID);
    QDomText t = doc.createTextNode(src.messageId);
    ret.appendChild(node);
    node.appendChild(t);

    // sender id
    node = doc.createElement(NODE_MESSAGE_SENDER_ID);
    t = doc.createTextNode(src.senderId);
    ret.appendChild(node);
    node.appendChild(t);

    // sender name
    node = doc.createElement(NODE_MESSAGE_SENDER_NAME);
    t = doc.createTextNode(src.senderName);
    ret.appendChild(node);
    node.appendChild(t);

//    // recepient id
//    node = doc.createElement(NODE_MESSAGE_RECEPIENT_ID);
//    t = doc.createTextNode(src.recepientId);
//    ret.appendChild(node);
//    node.appendChild(t);

//    // recepient name
//    node = doc.createElement(NODE_MESSAGE_RECEPIENT_NAME);
//    t = doc.createTextNode(src.recepientName);
//    ret.appendChild(node);
//    node.appendChild(t);

    // time
    node = doc.createElement(NODE_MESSAGE_TIME);
    t = doc.createTextNode(src.time);
    ret.appendChild(node);
    node.appendChild(t);

    // text
    node = doc.createElement(NODE_MESSAGE_TEXT);
    t = doc.createTextNode(src.text);
    ret.appendChild(node);
    node.appendChild(t);

    // title
    node = doc.createElement(NODE_MESSAGE_TITLE);
    t = doc.createTextNode(src.title);
    ret.appendChild(node);
    node.appendChild(t);

    return ret;
}

QString Message::subject() {
    if (this->title.length() < 10) {
        this->title = subjectFromBody(this->text);
        return this->title;
    } else
        return this->title;
}

QString Message::subjectFromBody(QString messageBody) {
    // Choose subject for message as begin of body
    messageBody = messageBody.simplified();
    if (messageBody.isEmpty()) {
        return DEFAULT_SUBJECT;
    } else if (messageBody.length() <= SUBJECT_LENGTH) {
        return messageBody;
    } else {
        messageBody.truncate(SUBJECT_LENGTH);
        messageBody.truncate(messageBody.lastIndexOf(QRegExp("\\s")));
        messageBody = messageBody.trimmed();
        messageBody.append(DEFAULT_SUBJECT);
        return messageBody;
    }
}

Message& Message::operator =(Message const &src) {
    Message::copyData(this, &src);
    return *this;
}
