#ifndef ALBUM_H
#define ALBUM_H

#include <QString>
#include <QMetaType>
#include <QDomDocument>
#include <QFile>
#include <QDebug>

class Album;
typedef QList<Album> AlbumList;

#include "photo.h"

#define FILE_PHOTOS_DATA "photos_%1_%2.xml"
#define NODE_PHOTOS_ROOT "photos"


#define NODE_ALBUM_ROOT "album"
#define NODE_ALBUM_ID "id"
#define NODE_ALBUM_TITLE "title"
#define NODE_ALBUM_DESCRIPTION "description"
#define NODE_ALBUM_SIZE "size"
#define NODE_ALBUM_CREATE "create"
#define NODE_ALBUM_UPDATE "update"
#define NODE_ALBUM_ICON "icon"
#define NODE_ALBUM_ICON_URL "iconUrl"


class Album : public QObject
{
    Q_OBJECT

public:
    Album();
    Album(const Album& src);
    ~Album();

    // album ID from service
    QString albumId;

    // friend ID
    QString ownerId;

    // album title
    QString title;

    // album description
    QString description;

    // album's creation time
    QString time_create;

    // album's update time
    QString time_update;

    // the num of images in album
    int size;

    // album icon
    QString icon;

    // url album icon 
    QString icon_url;

    // the name of account of this album (not stored in cache)
    QString accountId;

    // store album data to XML format
    QDomElement toQDomElement(QDomDocument doc);

    // load album from XML struct
    static Album fromQDomElement(QDomElement fr, QString accountId, QString friendId);

    // load photo list from cache file.
    PhotoList getPhotoList();

    // set photo list and store it to cache file.
    static void setPhotoList(PhotoList list, QString accountId, QString friendId, QString albumId);

    Album& operator=(const Album&);

};

Q_DECLARE_METATYPE(Album)
Q_DECLARE_METATYPE(AlbumList)


#endif // ALBUM_H
