#!/bin/sh

# Check for lockfile
if test -f /opt/menu-update/lock
then 
  exit 1
fi

# Create lockfile
touch /opt/menu-update/lock

# start user info
/opt/menu-update/mymenu-update-info &


###################################################################################
###                        INFORMATION                                          ###
### apt-get WGET is only in this script until MyMenu is on the maemo repository ###
###################################################################################

# check for wget
if test -f /var/lib/dpkg/lock
then
rm /var/lib/dpkg/lock
echo lock entfernt
fi

if test -f /usr/bin/wget 
then
echo wget installed
else
echo install wget
apt-get install wget
fi

###################################################################################
### apt-get WGET is only in this script until MyMenu is on the maemo repository ###
###################################################################################

# pathvariable
menu=/opt/menu-update
menui=/opt/menu-update/mymenu
menun=/opt/menu-update/mymenu/new
menu_new=$menun/category
menu_old=$menu/category


# clear old files
rm -r $menun/*
cd $menun
wget http://maemo.3ion.at/category
wget http://maemo.3ion.at/install

# filevariable
install_old='$menui/install.sh'
install_new='$menun/install'
hildon_menu='/opt/menu-update/mymenu/new/hildon.menu'


# check for update 
if [ "$menu_old" -ot "$menu_new" ]; then
cp $menun/category $menu/
fi

touch /opt/menu-update/mymenu/new/hildon.menu

# create hildon.menu

###################################################################################
###          Start check for installed apps                                     ###
###################################################################################

newline='\n'

for i in $(ls /usr/share/applications/hildon | grep .desktop)
do

desktop=`cat  /opt/menu-update/category | grep -i "$i"`

test=`echo $desktop | grep -i "Science+learn"|cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss="-"
fi
test=`echo $desktop | grep -i "office"|cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss1="-"
fi
test=`echo $desktop | grep -i "Multimedia"|cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss2="-"
fi
test=`echo $desktop | grep -i "Programmierung"|cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss3="-"
fi
test=`echo $desktop | grep -i "Spiele" |cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss4="-"
fi
test=`echo $desktop | grep -i "Graphics" |cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss5="-"
fi
test=`echo $desktop | grep -i "Netzwerk" |cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss6="-"
fi
test=`echo $desktop | grep -i "System" |cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss7="-"
fi
test=`echo $desktop | grep -i "sonstige" |cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss8="-"
fi
test=`echo $desktop | grep -i "gps"  |cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss9="-"
fi
test=`echo $desktop | grep -i "tools"  |cut -d ":" -f1`
if [ ${#test} -gt 0 ]; then
	ergebniss10="-"
fi

done
###################################################################################
###         Stop check for installed apps                                       ###
###################################################################################


##########################################################################################
#     start creating menu.hildon                                                         #
##########################################################################################

#### Main Menu ####
echo '<!DOCTYPE Menu PUBLIC "-//freedesktop//DTD Menu 1.0//EN"
 "http://www.freedesktop.org/standards/menu-spec/menu-1.0.dtd">

<!-- Created & Edited by Manfred Weiß (C) - 2010
     you can freely rewrite & distripute this Script....
     Mail: maemo@3ion.at -->

<Menu>

  <Name>Main</Name>

  <!-- Search the default locations -->
  <AppDir>/usr/share/applications/hildon</AppDir>
  <DirectoryDir>/usr/share/applications/hildon/directory</DirectoryDir>

  <Include>
    <Filename>calendar.desktop</Filename>
    <Filename>osso-addressbook.desktop</Filename>
    <Filename>rtcom-call-ui.desktop</Filename>
    <Filename>camera-ui.desktop</Filename>
    <Filename>rtcom-messaging-ui.desktop</Filename>
  </Include>
  <Layout>
    <Filename>calendar.desktop</Filename>
    <Filename>osso-addressbook.desktop</Filename>
    <Filename>rtcom-call-ui.desktop</Filename>
    <Filename>camera-ui.desktop</Filename>
    <Filename>rtcom-messaging-ui.desktop</Filename>
  </Layout>

' >> $hildon_menu

#### Science & Learn ####
if [ ${#ergebniss} -gt 0 ]; then
echo '
  <Menu>
    <Name>Science+learn</Name>
    <Directory>education.directory</Directory>
    <Include>' >> $hildon_menu
    cat $menu/category | grep -i "Science+learn" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no Science+learn
fi

#### Office ####
if [ ${#ergebniss1} -gt 0 ]; then
echo '   
  <Menu>
    <Name>Office</Name>
    <Directory>office.directory</Directory>
    <Include>' >> $hildon_menu
cat $menu/category | grep -i "office" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no office
fi

#### Multimedia ####
if [ ${#ergebniss2} -gt 0 ]; then
echo '   
  <Menu>
    <Name>Multimedia</Name>
    <Directory>audiovideo.directory</Directory>
    <Include>' >> $hildon_menu
cat $menu/category | grep -i "Multimedia" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no multimedia
fi

#### Development ####
if [ ${#ergebniss3} -gt 0 ]; then
echo '   
  <Menu>
    <Name>Programmierung</Name>
    <Directory>development.directory</Directory>
    <Include>' >> $hildon_menu
cat $menu/category | grep -i "Programmierung" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no Programmierung
fi

#### Games ####
if [ ${#ergebniss4} -gt 0 ]; then
echo '   
  <Menu>
    <Name>Spiele</Name>
    <Directory>game.directory</Directory>
    <Include>' >> $hildon_menu
cat $menu/category | grep -i "Spiele" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no Spiele
fi

#### Graphics ####
if [ ${#ergebniss5} -gt 0 ]; then
echo '   
   <Menu>
    <Name>Graphics</Name>
    <Directory>graphics.directory</Directory>
    <Include>' >> $hildon_menu
cat $menu/category | grep -i "Graphics" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no Graphics
fi

#### Network ####
if [ ${#ergebniss6} -gt 0 ]; then
echo '   
  <Menu>
    <Name>Netzwerk</Name>
    <Directory>network.directory</Directory>
    <Include>' >> $hildon_menu
cat $menu/category | grep -i "Netzwerk" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no Netzwerk
fi

#### GPS ####
if [ ${#ergebniss9} -gt 0 ]; then
echo '   
  <Menu>
    <Name>GPS</Name>
    <Directory>geo.directory</Directory>
    <Include>' >> $hildon_menu
cat $menu/category | grep -i "gps" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no gps
fi

#### System ####
if [ ${#ergebniss7} -gt 0 ]; then
echo '   
  <Menu>
    <Name>System</Name>
    <Directory>system.directory</Directory>
    <Include>' >> $hildon_menu
cat $menu/category | grep -i "System" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no System
fi

#### Other ####
if [ ${#ergebniss8} -gt 0 ]; then
echo '   
  <Menu>
    <Name>sonstige</Name>
    <Directory>other.directory</Directory>
    <OnlyUnallocated/>
    <Include>
      <All/>' >> $hildon_menu
cat $menu/category | grep -i "sonstige" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no sonstige
fi

#### Tools ####
if [ ${#ergebniss10} -gt 0 ]; then
echo '   
  <Menu>
    <Name>tools</Name>
    <Directory>tools.directory</Directory>
    <OnlyUnallocated/>
    <Include>' >> $hildon_menu
cat $menu/category | grep -i "tools" | awk -F":" '{ print $1 }' >> $hildon_menu
echo '    </Include>
  </Menu>' >> $hildon_menu
else
   echo no tools
fi
echo '</Menu>' >> $hildon_menu


/etc/init.d/hildon-desktop stop
rm /etc/xdg/menus/hildon.menu
cp $hildon_menu /etc/xdg/menus
sleep 1
/etc/init.d/hildon-desktop start


if [ "$install_old" -ot "$install_new" ]; then
rm $menui/install.sh
mv $menun/install $menui/install.sh
chmod 755 $menui/install.sh
$menui/install.sh
else
echo no update
fi



rm /opt/menu-update/lock

## FINAL TEST
echo FINAL TEST
COUNTER=10
until [  $COUNTER -lt 1 ]; do
check=`ps axf | pgrep hildon-desktop`

if [ "$COUNTER" = 10 ]; then
 echo $check >> 10
  elif [ "$COUNTER" = 1 ]; then
    echo $check >> 1
else
echo 
fi
sleep 1
    let COUNTER-=1
done

if [ "$(cat 10)" = "$(cat 1)"  ]; then
 echo NO ERROR
else
 echo ERROR = RESTORING ORIGINAL SETUP
 if [ "$(uname -r)" = "2.6.28-omap1" ]; then


# remove configuration
filename="/etc/xdg/menus/hildon.menu"
if test -f /etc/xdg/menus/hildon.menu
then
 rm $filename
fi 

touch $filename


# Set Menu to orginal strukture.
#DEBHELPER#

echo '<!DOCTYPE Menu PUBLIC "-//freedesktop//DTD Menu 1.0//EN"
 "http://www.freedesktop.org/standards/menu-spec/menu-1.0.dtd">

<Menu>

  <Name>Main</Name>

  <!-- Search only in the hildon directory. -->
  <AppDir>/usr/share/applications/hildon</AppDir>
  <DirectoryDir>/usr/share/applications/hildon</DirectoryDir>

  <Include>
    <Filename>browser.desktop</Filename>
    <Filename>mediaplayer.desktop</Filename>
    <Filename>calendar.desktop</Filename>
    <Filename>image-viewer.desktop</Filename>
    <Filename>osso-addressbook.desktop</Filename>
    <Filename>rtcom-call-ui.desktop</Filename>
    <Filename>nokia-maps.desktop</Filename>
    <Filename>camera-ui.desktop</Filename>
    <Filename>modest.desktop</Filename>
    <Filename>rtcom-messaging-ui.desktop</Filename>
    <Filename>worldclock.desktop</Filename>
    <Filename>osso_calculator.desktop</Filename>
    <Filename>ovi.desktop</Filename>
    <Filename>hildon-control-panel.desktop</Filename>
  </Include>

  <Layout>
    <Filename>browser.desktop</Filename>
    <Filename>mediaplayer.desktop</Filename>
    <Filename>calendar.desktop</Filename>
    <Filename>image-viewer.desktop</Filename>
    <Filename>osso-addressbook.desktop</Filename>
    <Filename>rtcom-call-ui.desktop</Filename>
    <Filename>nokia-maps.desktop</Filename>
    <Filename>camera-ui.desktop</Filename>
    <Filename>modest.desktop</Filename>
    <Filename>rtcom-messaging-ui.desktop</Filename>
    <Filename>worldclock.desktop</Filename>
    <Filename>osso_calculator.desktop</Filename>
    <Filename>ovi.desktop</Filename>
    <Filename>hildon-control-panel.desktop</Filename>
    <Menuname>Applications</Menuname>
    <Merge type="all"/>
  </Layout>

  <MergeDir>hildon/</MergeDir>

</Menu> ' >> $filename


/etc/init.d/hildon-desktop stop
sleep 5
/etc/init.d/hildon-desktop start

exit 1

 else

# remove configuration
filename="/etc/xdg/menus/hildon.menu"
if test -f /etc/xdg/menus/hildon.menu
then
 rm $filename
fi 

touch $filename


# Set Menu to orginal strukture.
#DEBHELPER#

echo '<!DOCTYPE Menu PUBLIC "-//freedesktop//DTD Menu 1.0//EN"
 "http://www.freedesktop.org/standards/menu-spec/menu-1.0.dtd">
 
 <Menu>
 
   <Name>Main</Name>
   
     <!-- Search the default locations -->
      <AppDir>/usr/share/applications/hildon</AppDir>
      <DirectoryDir>/usr/share/applications/hildon</DirectoryDir>
         
      <Include>
        <Filename>browser.desktop</Filename>
        <Filename>mediaplayer.desktop</Filename>
        <Filename>calendar.desktop</Filename>
        <Filename>image-viewer.desktop</Filename>
        <Filename>osso-addressbook.desktop</Filename>
        <Filename>rtcom-call-ui.desktop</Filename>
        <Filename>nokia-maps.desktop</Filename>
        <Filename>camera-ui.desktop</Filename>
        <Filename>modest.desktop</Filename>
        <Filename>rtcom-messaging-ui.desktop</Filename>
        <Filename>worldclock.desktop</Filename>
        <Filename>osso_calculator.desktop</Filename>
        <Filename>ovi.desktop</Filename>
        <Filename>hildon-control-panel.desktop</Filename>
      </Include>
                                          
      <Menu>
        <Name>Applications</Name>
        <Directory>applications.directory</Directory>
        <OnlyUnallocated/>
   <Include>
     <All/>
     </Include>
   </Menu>
   </Menu> ' >> $filename


/etc/init.d/hildon-desktop stop
sleep 5
/etc/init.d/hildon-desktop start
exit 1
 fi
fi


killall mymenu-update-info
exit 0

