#!/usr/bin/env python2.5
# -*- coding: utf-8 -*-

#
#    Copyright © 2009 - 2010 Michael Werle
#
#    Small module to abstract Maemo connection handling.
#
# V1 2010.02.04


__program__ = 'netconn'
__license__ = 'bsd'
__authors__ = ["Michael Werle <mwerle@gmail.com>"]
__version__ = '1.0.0'

try:
	import conic
	import threading
        import gtk
	gtk.gdk.threads_init()
	USE_CONIC = True
except ImportError:
	USE_CONIC = False

class NetworkConn:
    def conn_event_cb(self, connection, event):
        self.cond.acquire()

        status = event.get_status()
        error = event.get_error()
        iap_id = event.get_iap_id()
        bearer = event.get_bearer_type()
        print "(CONN_EVENT (%s, %s, %i, %i)" % (iap_id, bearer, status, error)
        self.connStatus[iap_id] = status

#        if status == conic.STATUS_CONNECTED:
#            self.connected = True
#            print "conn_cb: CONNECTED"
#        if status == conic.STATUS_DISCONNECTING:
#            self.connected = False
#            print "conn_cb: DISCONNECTING"
#        if status == conic.STATUS_DISCONNECTED:
#            self.connected = False
#            print "conn_cb: DISCONNECTED"
        self.cond.notify()
        self.cond.release()
        return

    def connect(self):
    	global USE_CONIC
        if not USE_CONIC:
            return True
        if not self.isConnected():
            print "connect: Connecting..."
            self.cond.acquire()
            self.conn.request_connection(conic.CONNECT_FLAG_NONE)
            print "connect: Waiting for connection..."
            self.cond.wait(15.0) # wait up to 15sec
            self.cond.release()
            print "connect: Done"
        return self.isConnected()

    def isConnected(self):
    	global USE_CONIC
        if not USE_CONIC:
            return True

        try:
            self.cond.acquire()
            for iap_id,status in self.connStatus.iteritems():
                if status == conic.STATUS_CONNECTED:
                    return True
            return False
        finally:
            self.cond.release()

    def __init__(self):
        self.connStatus = {}
    	global USE_CONIC
        if USE_CONIC:
            self.conn = conic.Connection()
            self.conn.connect("connection-event", self.conn_event_cb)
            self.conn.set_property("automatic-connection-events", True)

            self.cond = threading.Condition()
