#!/usr/bin/env python2.5
# -*- coding: utf-8 -*-

#
#    Copyright © 2009 - 2010 Michael Werle
#
#    This is a simple little program to download and
#    display the current London Tube status.
#


__program__ = 'mwtube'
__license__ = 'bsd'
__authors__ = ["Michael Werle <mwerle@gmail.com>"]
__version__ = '0.0.3'
__website__ = 'http://mwtube.garage.maemo.org/'

import pygtk
#pygtk.require('2.0')
import gtk
import gobject
import osso
import hildon
import pango
import os
import sys

try:
	import conic
	import threading
	gtk.gdk.threads_init()
	USE_CONIC = True
except ImportError:
	USE_CONIC = False

import pycurl
import curl
import simplejson as json

#class SampleConn:
#    response = {u'body': u'{"response":{"lines":[{"name":"Bakerloo","id":"bakerloo","status":"good service","messages":[],"status_starts":"Sat, 12 Dec 2009 18:23:03 +0000","status_ends":"","status_requested":"Sun, 13 Dec 2009 17:07:12 +0000"},{"name":"Central","id":"central","status":"part closure","messages":["Saturday 12 and Sunday 13 December, suspended between Leytonstone and Hainault via Newbury Park. Rail replacement buses operate.\\r\\n\\r\\nBus service: between Leytonstone and Hainault, calling at Wanstead, Redbridge, Gants Hill, Newbury Park, Barkingside and Fairlop."],"status_starts":"Sat, 12 Dec 2009 16:55:02 +0000","status_ends":"","status_requested":"Sun, 13 Dec 2009 17:07:12 +0000"},{"name":"Circle","id":"circle","status":"good service","messages":[],"status_starts":"Fri, 11 Dec 2009 20:59:02 +0000","status_ends":"","status_requested":"Sun, 13 Dec 2009 17:07:12 +0000"},{"name":"District","id":"district","status":"good service","messages":[],"status_starts":"Sat, 12 Dec 2009 16:13:02 +0000","status_ends":"","status_requested":"Sun, 13 Dec 2009 17:07:12 +0000"},{"name":"Docklands Light Railway","id":"docklands","status":"unknown","messages":["DOCKLANDS LIGHT RAILWAY: Saturday 12 and Sunday 13 December, suspended between Westferry, Beckton and Woolwich Arsenal. Rail replacement bus services operate."],"status_starts":"Sat, 12 Dec 2009 07:20:02 +0000","status_ends":"","status_requested":"Sun, 13 Dec 2009 17:07:12 +0000"},{"name":"Hammersmith &amp; City","id":"hammersmithcity","status":"good service","messages":[],"status_starts":"Sat, 12 Dec 2009 07:13:02 +0000","status_ends":"","status_requested":"Sun, 13 Dec 2009 17:07:12 +0000"},{"name":"Jubilee","id":"jubilee","status":"part closure","messages":["Saturday 12 and Sunday 13 December, suspended between Stanmore and West Hampstead. Two rail replacement bus services operate.\\r\\n\\r\\nService C: between Stanmore and Stonebridge Park, calling at Canons Park, Queensbury, Kingsbury and Wembley Park.\\r\\n\\r\\nService D: between Wembley Park and Finchley Road, calling at Neasden, Dollis Hill, Willesden Green, Kilburn and West Hampstead."],"status_starts":"Sun, 13 Dec 2009 11:13:02 +0000","status_ends":"","status_requested":"Sun, 13 Dec 2009 17:07:12 +0000"},{"name":"Metropolitan","id":"metropolitan","status":"part closure","messages":["Saturday 12 and Sunday 13 December, suspended between Harrow-on-the-Hill and Aldgate. Rail replacement bus services operate.\\r\\n\\r\\nService A: between Wembley Park and Harrow-on-the-Hill, calling at Preston Road and Northwick Park.\\r\\n\\r\\nService B (early morning and late evening only): between Stonebridge Park and Harrow-on-the-Hill.\\r\\n\\r\\nLondon Underground tickets will be accepted on Chiltern Railways between London Marylebone and Harrow-on-the-Hill."],"status_starts":"Sat, 12 Dec 2009 22:15:03 +0000","status_ends":"","status_requested":"Sun, 13 Dec 2009 17:07:12 +0000"},{"name":"Northern","id":"northern","status":"good service","messages":[],"status_starts":"Wed, 09 Dec 2009 13:13:02 +0000","status_ends":"","status_requested":"Sun, 13 Dec 2009 17:07:12 +0000"},{"name":"Piccadilly","id":"piccadilly","status":"good service","messages":[],"status_starts":"Sat, 12 Dec 2009 16:25:01 +0000","status_ends":"","status_requested":"Sun, 13 Dec 2009 17:07:12 +0000"},{"name":"Victoria","id":"victoria","status":"good service","messages":[],"status_starts":"Sun, 13 Dec 2009 13:03:01 +0000","status_ends":"","status_requested":"Sun, 13 Dec 2009 17:07:12 +0000"},{"name":"Waterloo &amp; City","id":"waterloocity","status":"planned closure","messages":["Monday - Friday 0615 - 2148. Saturday 0800 - 1830. Closed Sunday and Public Holidays."],"status_starts":"Sat, 12 Dec 2009 18:34:02 +0000","status_ends":"","status_requested":"Sun, 13 Dec 2009 17:07:12 +0000"}]}}', u'headers': {'status': '200', 'content-length': '3764', 'content-location': u'http://api.tubeupdates.com/?method=get.status', 'x-powered-by': 'PHP/5.2.11', 'set-cookie': 'PHPSESSID=c3374b41c316749ef6ea3cd478d5b95c; path=/', 'expires': 'Thu, 19 Nov 1981 08:52:00 GMT', 'server': 'Apache/2.0.63 (Unix) mod_ssl/2.0.63 OpenSSL/0.9.8e-fips-rhel5 mod_bwlimited/1.4 PHP/5.2.11', 'pragma': 'no-cache', 'cache-control': 'no-store, no-cache, must-revalidate, post-check=0, pre-check=0', 'date': 'Sun, 13 Dec 2009 17:07:12 GMT', 'content-type': 'application/x-json'}}
#    #errResponse = {u'body': u'{"response":{"error":"Unrecognised lines value \'hogwarts\'"}}', u'headers': {'status': '200', 'content-length': '3764', 'content-location': u'http://api.tubeupdates.com/?method=get.status', 'x-powered-by': 'PHP/5.2.11', 'set-cookie': 'PHPSESSID=c3374b41c316749ef6ea3cd478d5b95c; path=/', 'expires': 'Thu, 19 Nov 1981 08:52:00 GMT', 'server': 'Apache/2.0.63 (Unix) mod_ssl/2.0.63 OpenSSL/0.9.8e-fips-rhel5 mod_bwlimited/1.4 PHP/5.2.11', 'pragma': 'no-cache', 'cache-control': 'no-store, no-cache, must-revalidate, post-check=0, pre-check=0', 'date': 'Sun, 13 Dec 2009 17:07:12 GMT', 'content-type': 'application/x-json'}}
#    errResponse = {u'body': u'{"response":{"error":"Not allowed!"}}', u'headers': {'status': '403', 'content-length': '3764', 'content-location': u'http://api.tubeupdates.com/?method=get.status', 'x-powered-by': 'PHP/5.2.11', 'set-cookie': 'PHPSESSID=c3374b41c316749ef6ea3cd478d5b95c; path=/', 'expires': 'Thu, 19 Nov 1981 08:52:00 GMT', 'server': 'Apache/2.0.63 (Unix) mod_ssl/2.0.63 OpenSSL/0.9.8e-fips-rhel5 mod_bwlimited/1.4 PHP/5.2.11', 'pragma': 'no-cache', 'cache-control': 'no-store, no-cache, must-revalidate, post-check=0, pre-check=0', 'date': 'Sun, 13 Dec 2009 17:07:12 GMT', 'content-type': 'application/x-json'}}
#    def request_get(self):
#    #    return self.response
#        return self.errResponse


class NetworkConn:
    def conn_event_cb(self, connection, event):
        status = event.get_status()
        error = event.get_error()
        self.cond.acquire()
        if status == conic.STATUS_CONNECTED:
            self.isConnected = True
            print "conn_cb: CONNECTED"
        if status == conic.STATUS_DISCONNECTING:
            self.isConnected = False
            print "conn_cb: DISCONNECTING"
        if status == conic.STATUS_DISCONNECTED:
            self.isConnected = False
            print "conn_cb: DISCONNECTED"
        self.cond.notify()
        self.cond.release()
        return

    def connect(self):
    	global USE_CONIC
        if not USE_CONIC:
            return True
        if False == self.isConnected:
            conn = conic.Connection()
            conn.connect("connection-event", self.conn_event_cb)
            print "connect: Connecting..."
            self.cond = threading.Condition()
            self.cond.acquire()
            conn.request_connection(conic.CONNECT_FLAG_NONE)
            print "connect: Waiting for connection..."
            self.cond.wait(10.0) # wait up to 10sec
            self.cond.release()
            print "connect: Done"
        return self.isConnected

    def __init__(self):
        self.isConnected = False


class TubeStatus(hildon.Program):

    # This is our global Tube status, which we persist.
    tubeLines = { "lines" : () }

    # This is the name of our persistent state file.
    data_file = os.path.expanduser('~/.mwtube')

    # Loads a serialised JSON object
    # Object = {"lines":[ <Linedata> ] }
    # Linedata = { "status":<str>, ...  }
    def load(self):
        try:
            fp = open(self.data_file, 'r')
            data = json.load(fp)
            fp.close()
            if not data.has_key('lines'):
                return False
            self.tubeLines = data
            return True
        except IOError:
            print 'WARNING - could not read from data file'
        #except:
        #    print 'ERROR - caught unexpected exception during load: ', sys.exc_info()[0]
        return False


    def save(self):
        try:
            fp = open(self.data_file, 'w')
            json.dump(self.tubeLines, fp)
            fp.close()
        except IOError:
            print 'WARNING - could not write to data file'
        except:
            print 'ERROR - caught unexpected exception during load: ', sys.exc_info()[0]

    # Tube line colours - tuple of background/foreground colours
    line_colours = {
        'bakerloo' : ( gtk.gdk.color_parse('#AE6118'), gtk.gdk.color_parse('#FFF') ),
        'central' : ( gtk.gdk.color_parse('#E41F1F'), gtk.gdk.color_parse('#FFF') ),
        'circle' : ( gtk.gdk.color_parse('#F8D42D'), gtk.gdk.color_parse('#113B92') ),
        'district' : ( gtk.gdk.color_parse('#00A575'), gtk.gdk.color_parse('#FFF') ),
        'hammersmithcity' : ( gtk.gdk.color_parse('#E899A8'), gtk.gdk.color_parse('#113B92') ),
        'jubilee' : ( gtk.gdk.color_parse('#8F989E'), gtk.gdk.color_parse('#FFF') ),
        'metropolitan' : ( gtk.gdk.color_parse('#893267'), gtk.gdk.color_parse('#FFF') ),
        'northern' : ( gtk.gdk.color_parse('#000000'), gtk.gdk.color_parse('#FFF') ),
        'piccadilly' : ( gtk.gdk.color_parse('#0450A1'), gtk.gdk.color_parse('#FFF') ),
        'victoria' : ( gtk.gdk.color_parse('lightblue'), gtk.gdk.color_parse('#FFF') ),
        'waterloocity' : ( gtk.gdk.color_parse('#70C3CE'), gtk.gdk.color_parse('#113B92') ),
        'docklands' :  ( gtk.gdk.color_parse('#00BBB4'), gtk.gdk.color_parse('#FFF') ),
        }


    # Event handler for the About menu item
    def onAboutClicked(self, widget, event, data=None):
        # TODO: add PayPal button
        aw = gtk.AboutDialog()
        aw.set_name('mwTube')
        aw.set_logo(self.icon)
        aw.set_authors(__authors__)
        aw.set_version(__version__)
        aw.set_website(__website__)
        aw.set_comments('Display current tube status')
        aw.set_copyright('This application uses data from tubeupdates.com')
        try:
            fp = open('/usr/share/doc/mwtube/license', 'r')
            license = fp.read()
            fp.close()
        except IOError:
            license = 'This program is distributed under the Simplified BSD License.\nhttp://opensource.org/licenses/bsd-license.php\n\nCopyright (c) 2009 Michael Werle\nAll rights reserved.'
        aw.set_license(license)
        aw.show_all()
        return

    def onTubeDetailsClicked(self, widget, event, data=None):
        #detailWindow = gtk.Dialog(data['name'],self.window,gtk.DIALOG_MODAL|gtk.DIALOG_DESTROY_WITH_PARENT,(gtk.STOCK_OK,gtk.RESPONSE_ACCEPT))
        dw = hildon.StackableWindow()
        #dw.set_type_hint(gtk.gdk.WINDOW_TYPE_HINT_DIALOG)
        #dw.set_transient_for(self.window)
        #dw.set_modal(True)
        dw.set_title(data['name'])

        dw.vbox = gtk.VBox()
        dw.add(dw.vbox)

        #scroll = gtk.ScrolledWindow()
        #scroll.set_policy(gtk.POLICY_NEVER,gtk.POLICY_AUTOMATIC)
        scroll = hildon.PannableArea()
        dw.vbox.pack_start(scroll, True, True, 0)

        # Add status text and all messages
        #tv = gtk.TextView()
        tv = hildon.TextView()
        tv.set_editable(False)
        tv.unset_flags(gtk.CAN_FOCUS)
        tv.set_wrap_mode(gtk.WRAP_WORD)
        tb = tv.get_buffer()
        end = tb.get_end_iter()
        tb.insert(end, data['name'].upper())
        tb.insert(end, ': ')
        tb.insert(end, data['status'])
        tb.insert(end, '\n')
        for message in data['messages']:
                    tb.insert(end, message)
                    tb.insert(end, '\n')
        scroll.add_with_viewport(tv)

        label = gtk.Label('Last Updated: ' + data['status_requested'])
        dw.vbox.pack_start(label, False, False, 0)

        dw.show_all()


    def addTubeStatus(self, tubeStatus):
        # First, draw the name of the tube line
        # This is a label on an event box, so that we can render a background
        # colour as well as allow clicking if there is a problem with the service
        eb1 = gtk.EventBox()
        eb1.set_visible_window(True)
        attrlist=pango.AttrList()
        eb1.modify_bg(gtk.STATE_NORMAL, self.line_colours[tubeStatus['id']][0] )

        if len(tubeStatus['messages']) > 0:
            eb1.set_events(gtk.gdk.BUTTON_PRESS_MASK)
            eb1.connect("button_press_event", self.onTubeDetailsClicked, tubeStatus)

        label = gtk.Label(tubeStatus['name'])
        c = self.line_colours[tubeStatus['id']][1]
        attrlist.insert(pango.AttrForeground(c.red, c.green, c.blue,0,-1))
        attrlist.insert(pango.AttrWeight(pango.WEIGHT_BOLD,0,-1))
        label.set_attributes(attrlist)
        label.set_alignment(0, 0.5)
        label.show()
        eb1.add(label)
        self.table.attach(eb1, 0,1, self.pos, self.pos+1)
        eb1.show()

        # Now draw the status - same deal as for the name
        eb2 = gtk.EventBox()
        eb2.set_visible_window(True)
        attrlist=pango.AttrList()

        if len(tubeStatus['messages']) == 0:
            eb2.modify_bg(gtk.STATE_NORMAL, gtk.gdk.color_parse('white'))
            attrlist.insert(pango.AttrForeground(0,0,0 ,0,-1))
        else:
            eb2.modify_bg(gtk.STATE_NORMAL, gtk.gdk.color_parse('blue'))
            attrlist.insert(pango.AttrForeground(65535,65535,65535, 0,-1))
            eb2.set_events(gtk.gdk.BUTTON_PRESS_MASK)
            eb2.connect("button_press_event", self.onTubeDetailsClicked, tubeStatus)
        label = gtk.Label(tubeStatus['status'])
        label.set_alignment(0, 0.5)
        label.set_attributes(attrlist)
        label.show()
        eb2.add(label)
        self.table.attach(eb2, 1,2, self.pos, self.pos+1)
        eb2.show()


    def htmlDecode(self, s):
        s = s.replace("&lt;", "<")
        s = s.replace("&gt;", ">")
        # this has to be last:
        s = s.replace("&amp;", "&")
        return s


    # Re-generates the GUI from the current tube line data
    def updateTubeStatus(self):
        # TODO: test for error
        lines = self.tubeLines['lines']
        for child in self.table.get_children():
            self.table.remove(child)
        self.table.resize(len(lines), 2)
        self.pos = 0
        for line in lines:
            self.addTubeStatus(line)
            self.pos += 1

    def showMessage(self, message):
        #self.md = gtk.MessageDialog(parent=self.window,
        #                            flags=gtk.DIALOG_MODAL,
        #                            type=gtk.MESSAGE_INFO,
        #                            buttons=gtk.BUTTONS_CANCEL,
        #                            message_format=message)
        #hildon.hildon_gtk_window_set_progress_indicator(self.md, 1)
        #self.md.show()

        self.banner = hildon.hildon_banner_show_information(
            self.window, 
            "", "Updating Tube Status\n\nPlease wait...")

        #self.md = hildon.hildon_note_new_information(self.window, message)
        #self.md.show()
        hildon.hildon_gtk_window_set_progress_indicator(self.window, 1)

    def hideMessage(self):
        #hildon.hildon_gtk_window_set_progress_indicator(self.md, 0)
        #self.md.hide()
        #self.md.destroy()

        #banner = hildon.hildon_banner_show_information(
        #    self.window, 
        #    "", "Done")
        self.banner.hide()
        hildon.hildon_gtk_window_set_progress_indicator(self.window, 0)

    # Runs in own thread
    def doGetTubeStatus(self):
        gobject.idle_add(
                self.showMessage,
                "Updating Tube Status, please wait...")
        try:
            print "Trying to connect to network.."
            c = NetworkConn()
            if False == c.connect():
                raise Exception, "Could not connect to network."

            #conn = SampleConn()
            #connResponse = conn.request_get()
            baseUrl = "http://api.tubeupdates.com/"
            conn = curl.Curl(baseUrl)
            conn.set_option(pycurl.USERAGENT, 'mwTube/'+__version__)

            print "Trying to retrieve data..."
            connResponse = conn.get(params={'method':'get.status'})

            #if conn.header()['status'] != '200':
            #    print 'ERROR - server returned an error:', connResponse
            #    return
            
            # TODO: Should we log errors somewhere?
            apiResponse = self.htmlDecode(conn.body())
            parsedResponse = json.loads(apiResponse)['response']
            if parsedResponse.has_key('error'):
                errStr = 'ERROR\nServer could not process request.\nServer Error:' + parsedResponse['error']
                hildon.hildon_banner_show_information(self.window, "", errStr)
                return

            if not parsedResponse.has_key('lines'):
                errStr = 'ERROR\nServer Response is in an unexpected format.\nPlease ensure you have the latest version of mwTube.'
                hildon.hildon_banner_show_information(self.window, "", errStr)
                #print parsedResponse
                return

            self.tubeLines = parsedResponse
            gobject.idle_add( self.updateTubeStatus )
        except:
            #n = hildon.Note("information", self.window, "Could not retrieve Tube Status. Please check your connection.")
            #gtk.Dialog.run(n)
            print "Exception occurred!!"
            hildon.hildon_banner_show_information(
                self.window, 
                "", "ERROR\n\nCould not retrieve Tube Status.\nPlease check your connection.")
            return

        finally:
            print "Destroying modal dialog."
            gobject.idle_add( self.hideMessage )

    # Callbacks
    def onGetTubeStatusClick(self, widget, data=None):
        # Get & update the tube status in another thread
        threading.Thread(target=self.doGetTubeStatus).start()
            

    def delete_event(self, widget, event, data=None):
        self.save()
        # Change FALSE to TRUE and the main window will not be destroyed
        # with a "delete_event".
        return False

    def destroy(self, widget, data=None):
        gtk.main_quit()

    def __init__(self):
        hildon.Program.__init__(self)
        
        # load icon
        icon_theme = gtk.icon_theme_get_default()
        try:
            self.icon = icon_theme.load_icon(__program__, 48, 0)
        except:
            self.icon = icon_theme.load_icon(gtk.STOCK_MISSING_IMAGE, 48, 0)

        # create a new window
        self.window = hildon.StackableWindow()
        self.window.set_icon(self.icon)
        self.add_window(self.window)

        self.window.connect("delete_event", self.delete_event)
        self.window.connect("destroy", self.destroy)

        # Sets the border width of the window.
        self.window.set_border_width(10)
        self.window.set_title("Tube Status")
        #self.window.set_default_size(480,800)

        menu = self.create_menu()
        self.window.set_app_menu(menu)

        self.vbox = gtk.VBox(spacing=10)
        self.window.add(self.vbox)

        self.table = gtk.Table(columns=2)
        self.table.set_row_spacings(2)
        self.table.set_col_spacings(2)
        self.vbox.pack_start(self.table, True, True, 0)

        if self.load():
            self.updateTubeStatus()


    def create_menu(self):
        menu = hildon.AppMenu()
        button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        button.set_label('Update')
        button.connect("clicked", self.onGetTubeStatusClick, None)
        menu.append(button)
        button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        button.set_label('About')
        button.connect("clicked", self.onAboutClicked, None)
        menu.append(button)

        menu.show_all()
        return menu

    def main(self):
        self.window.show_all()
        gtk.main()

# If the program is run directly or passed as an argument to the python
# interpreter then create an instance and run it
if __name__ == "__main__":
    osso_c = osso.Context(__program__, __version__, False)
    ts = TubeStatus()
    ts.main()
