#ifndef TUBESTATUSMODEL_H
#define TUBESTATUSMODEL_H

#include "tubestatus.h"

#include <QAbstractTableModel>

class TubeStatusModel : public QAbstractTableModel
{
private:
    QList<TubeStatus>   tubeStatusList;
    int                 nunColumns;

public:
    TubeStatusModel(QObject * parent = 0);

//    bool insertRows(int position, int rows, const QModelIndex &index = QModelIndex());

//    bool StringListModel::setData(const QModelIndex &index,
//                                  const QVariant &value, int role);

    void setTubeStatusList(const QList<TubeStatus> & tubeStatusList);

    void setColumns(int columns = 2);

    /** function void setTubeStatus(const TubeStatus & ts)
     *
     * Updates the Tube Status for a given Tube Line.
     */
    void setTubeStatus(const TubeStatus & ts);

    int columnCount(const QModelIndex &parent = QModelIndex()) const;
    int rowCount(const QModelIndex & parent = QModelIndex()) const;
    //QModelIndex index(int row, int column, const QModelIndex &parent = QModelIndex()) const;

    QVariant headerData(int section, Qt::Orientation orientation, int role) const;
    QVariant data( const QModelIndex & index, int role = Qt::DisplayRole ) const;
};

#endif // TUBESTATUSMODEL_H
