#include "tubestatusmodel.h"

#include <math.h>

TubeStatusModel::TubeStatusModel(QObject * parent)
    : QAbstractTableModel(parent)
{
    this->nunColumns = 2;
}

//    bool TubeStatusModel::insertRows(int position, int rows, const QModelIndex &index = QModelIndex())
//    {
//        beginInsertRows(QModelIndex(), position, position+rows-1);

//        for (int row = 0; row < rows; ++row) {
//            tubeStatusList.insert(position, new TubeStatus());
//        }

//        endInsertRows();
//        return true;
//    }


//    bool TubeStatusModel::StringListModel::setData(const QModelIndex &index,
//                                  const QVariant &value, int role)
//    {
//        if (index.isValid() && role == Qt::EditRole) {
//            //stringList.replace(index.row(), value.toString());
//            emit dataChanged(index, index);
//            return true;
//        }
//        return false;
//    }


void TubeStatusModel::setColumns(int columns)
{
    this->nunColumns = columns;
    reset();
}

void TubeStatusModel::setTubeStatusList(const QList<TubeStatus> & tubeStatusList)
{
    this->tubeStatusList = tubeStatusList;
    reset();
}

/** function void setTubeStatus(const TubeStatus & ts)
     *
     * Updates the Tube Status for a given Tube Line.
     */
void TubeStatusModel::setTubeStatus(const TubeStatus & ts)
{
    for (int i = 0; i < tubeStatusList.count(); ++i )
    {
        if( tubeStatusList[i].getName() == ts.getName() )
        {
            int row = i / rowCount();
            int col = i % rowCount();

            tubeStatusList[i].setMessages(ts.getMessages());
            emit dataChanged(this->index(row, col), this->index(row,col));
            return;
        }
    }
    int row = (tubeStatusList.count()) / columnCount();
    int col = (tubeStatusList.count()) % columnCount();
    if( col == 0 )
        beginInsertRows(QModelIndex(), row, row);
    tubeStatusList.append(ts);
    if( col > 0 )
        endInsertRows();
    else
        emit dataChanged(this->index(row, col), this->index(row,col));
}

int TubeStatusModel::rowCount(const QModelIndex & parent) const
{
    Q_UNUSED(parent);
    //return 6;
    int count = tubeStatusList.count();
    int cols = columnCount();
    float calc = count / (float)cols;
    int rowCount = ceil(calc);
    //int rowCount = ceil(tubeStatusList.count() / (float)columnCount());
    return rowCount;
}

int TubeStatusModel::columnCount(const QModelIndex & parent) const
{
    Q_UNUSED(parent);
    return this->nunColumns;
}

//QModelIndex TubeStatusModel::index(int row, int column, const QModelIndex &/*parent*/) const
//{
//    //int listIdx = row * columnCount() + column;

//    QModelIndex idx = createIndex(row,column);
//    return idx;
//}

QVariant TubeStatusModel::headerData(int section, Qt::Orientation orientation, int role) const
{
    if (role != Qt::DisplayRole)
        return QVariant();

    if( orientation == Qt::Horizontal ) {
        switch(section) {
        case 0:
            return QVariant("Col 1");
        case 1:
            return QVariant("Col 2");
        default:
            return QVariant();
        }
    } else {
        return QVariant(section+1);
    }
    return QVariant();
}

QVariant TubeStatusModel::data( const QModelIndex & index, int role) const
{
    if (!index.isValid())
        return QVariant();

    if (role == Qt::TextAlignmentRole) {
        return int(Qt::AlignRight | Qt::AlignVCenter);
    } else if (role == Qt::DisplayRole) {
        // 0,0 (0)  0,1 (1)
        // 1,0 (2)  1,1 (3)
        // 2,0 (4)  2,1 (5)
        int idx = index.row() * columnCount() + index.column();

        if( idx >= tubeStatusList.count() )
            return QVariant();
        return QVariant::fromValue(tubeStatusList[idx]);
    }
    return QVariant();
}
