#ifndef TUBESTATUSDELEGATE_H
#define TUBESTATUSDELEGATE_H

#include <QItemDelegate>
#include <QStyledItemDelegate>
#include <QPainter>

#include "tubestatus.h"

class TubeStatusDelegate : public QStyledItemDelegate
{
    Q_OBJECT
public:
    explicit TubeStatusDelegate(QObject *parent = 0);
    void paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const;
    QSize sizeHint(const QStyleOptionViewItem & option, const QModelIndex & index) const;

private:
    void doPaint( QPainter *painter, const QStyleOptionViewItem &option, const TubeStatus & tubeStatus ) const;
    QColor getForeground(const TubeStatus & tubeStatus) const;
    QColor getBackground(const TubeStatus & tubeStatus) const;

signals:

public slots:

};

#endif // TUBESTATUSDELEGATE_H
