#include "tubestatus.h"

#include <qjson/parser.h>


TubeStatus::TubeStatus()
{
    clear();
}

TubeStatus::TubeStatus(const QVariant & data)
{
    fromQVariant(data);
}


TubeStatus::TubeStatus(const QString & /*json*/)
{
    //{"name":"Bakerloo",
    // "id":"bakerloo",
    // "status":"good service",
    // "messages":[],
    // "status_starts":"Sat, 12 Dec 2009 18:23:03 +0000",
    // "status_ends":"",
    // "status_requested":"Sun, 13 Dec 2009 17:07:12 +0000"}

    // TODO: parse JSON object string

//    QJson::Parser parser;
//    bool ok;

//    QVariantMap ts = parser.parse(json, &ok);
//    if( !ok ) {
//        qErrnoWarning("Could not parse Tube Status as JSON");
//        return;
//    }
//    this->key = ts["id"].toString();
//    this->name = ts["name"].toString();
//    this->status = ts["status"].toString();
//    foreach( QVariant message, ts["messages"].toList() ) {
//        this->messages.append(message.toString());
//    }

    qDebug("Not Implemented yet!");
}

TubeStatus::TubeStatus(const QString & key, const QString & name, const QString & status, const QStringList & messages)
{
    setKey(key);
    setName(name);
    setStatus(status);
    setMessages(messages);
}

TubeStatus::~TubeStatus()
{
}

void TubeStatus::clear()
{
    this->key = QString();
    this->name = QString();
    this->status = QString();
    this->messages = QStringList();
}


void TubeStatus::fromQVariant(const QVariant &data)
{
    clear();

    if( !data.canConvert<QVariantMap>() )
        return;

    QVariantMap line = data.toMap();
    setKey(line["id"].toString());
    setName(line["name"].toString());
    setStatus(line["status"].toString());
    setMessages(line["messages"].toStringList());
    statusRequestedTime = fromHtml(line["status_requested"].toString());
}

QVariant TubeStatus::toQVariant() const
{
    QVariantMap ret;
    ret["id"] = key;
    ret["name"] = name;
    ret["status"] = status;
    QVariantList msgList;
    foreach(QString message, messages) {
        msgList.append(message);
    }
    ret["messages"] = msgList;
    return ret;
}

void TubeStatus::setKey(const QString & newKey)
{
    this->key = fromHtml(newKey);
}

QString TubeStatus::getKey() const
{
    return this->key;
}

void TubeStatus::setName(const QString & newName)
{
    this->name = fromHtml(newName);
}

QString TubeStatus::getName() const
{
    return this->name;
}

void TubeStatus::setStatus(const QString & newStatus)
{
    this->status = fromHtml(newStatus);
}

QString TubeStatus::getStatus() const
{
    return this->status;
}

const QStringList & TubeStatus::getMessages() const
{
    return this->messages;
}

QString TubeStatus::getRequestedTime() const
{
    return this->statusRequestedTime;
}

void TubeStatus::setMessages(const QStringList & newMessages)
{
    this->messages.clear();
    foreach(QString msg, newMessages)
        addMessage(msg);
}

void TubeStatus::addMessage(const QString & newMessage)
{
    this->messages.append(fromHtml(newMessage));
}

void TubeStatus::clearMessages()
{
    this->messages.clear();
}

int TubeStatus::numMessages() const
{
    return this->messages.count();
}

bool TubeStatus::isOk() const
{
    if( numMessages() >  0 )
        return false;

    return isGoodService();
}

bool TubeStatus::isGoodService() const
{
    return QString::compare(this->status, "Good Service", Qt::CaseInsensitive) == 0;
}


QString TubeStatus::fromHtml(const QString &str, bool * ok)
{
    QString dest;
    const QChar * src = str.constData();

    for( int i = 0; i < str.size(); ++i  )
    {
        if (src[i] == '&')
        {
            int endIdx = str.indexOf(";", i);
            i++;

            if (endIdx < 0 || endIdx > i+7) // &#12345;
                goto malformed;

            if (src[i] == '#')
            {
                int n;
                int base = 10;
                bool ok;

                ++i;

                if (src[i] == 'x') {
                    ++i;
                    base = 16;
                }
                n = QString(src+i, endIdx-i).toInt(&ok, base);

                if( !ok )
                    goto malformed;

                dest.append(n);
            }
            else {
                if( src[i] == 'a' && src[i+1] == 'm' && src[i+2] == 'p' && src[i+3] == ';' ) {
                    dest.append('&');
                } else if( src[i] == 'l' && src[i+1] == 't' && src[i+2] == ';' ) {
                        dest.append('<');
                } else if( src[i] == 'g' && src[i+1] == 't' && src[i+2] == ';' ) {
                        dest.append('>');
                } else if(  src[i] == 'n' && src[i+1] == 'b' && src[i+2] == 's' && src[i+3] == 'p' ) {
                        dest.append(' ');
                } else if(  src[i] == 'c' && src[i+1] == 'o' && src[i+2] == 'p' && src[i+3] == 'y' ) {
                    dest.append("©");
                } else if(  src[i] == 'q' && src[i+1] == 'u' && src[i+2] == 'o' && src[i+3] == 't' ) {
                    dest.append('"');
                } else if(  src[i] == 'r' && src[i+1] == 'e' && src[i+2] == 'g' && src[i+3] == ';' ) {
                    dest.append("®");
                } else if(  src[i] == 'a' && src[i+1] == 'p' && src[i+2] == 'o' && src[i+3] == 's' ) {
                    dest.append('\'');
                } else {
                    goto malformed;
                }
            }

            i = endIdx; // src[i] == ';'
        }
        else {
            dest.append(src[i]);
        }
    }

    if(ok)
        *ok = true;
    return dest;

malformed:
    if(ok)
        *ok = false;
    return dest;
}
