#include "settingsdialog.h"
#include "ui_settingsdialog.h"

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);

#ifdef Q_WS_MAEMO_5
    // TODO: Generate a Hildon GUI instead of a generic one
#endif
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}


void SettingsDialog::setAutoConnect(bool autoConnect)
{
    ui->checkAutoConnect->setChecked(autoConnect);
}

bool SettingsDialog::getAutoConnect() const
{
    return ui->checkAutoConnect->isChecked();
}

void SettingsDialog::setAutoUpdate(bool autoUpdate)
{
    ui->checkAutoUpdate->setChecked(autoUpdate);
}

bool SettingsDialog::getAutoUpdate() const
{
    return ui->checkAutoUpdate->isChecked();
}

void SettingsDialog::setRotation(int rotationType)
{
    ui->comboBox->setCurrentIndex(rotationType);
}

SettingsDialog::RotationType SettingsDialog::getRotation() const
{
    switch( ui->comboBox->currentIndex() ) {
    case 0:
        return ROTATE_LANDSCAPE;
    case 1:
        return ROTATE_PORTRAIT;
    case 2:
        return ROTATE_AUTO;
    default:
        //qDebug() << "INTERNAL ERROR - invalid rotation style: " << ui->comboBox->currentIndex();
        return ROTATE_LANDSCAPE;
    }
}

void SettingsDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
