def __get_url_from_msn_results_page (page, max_results):

    if (not page):
        return

    current_option = None
    starting_at = 0

    for i in range (0, max_results):
        # Iterate until find a jpeg
        start = page.find ("furl=", starting_at)
        if (start == -1):
            yield None
        end = page.find ("\"", start + len ("furl="))
        current_option = page [start + len ("furl="): end].replace ("amp;", "")
        if (current_option.lower().endswith (".jpg") or
            current_option.lower().endswith (".jpeg")):
            yield current_option
        starting_at = end
    yield None


if __name__ == "__main__":

    import os
    CACHE_LOCATION = os.path.join (os.getenv ("HOME"), ".cache", "mussorgsky")

    p = open ("test.html").read ()
    options = __get_url_from_msn_results_page (p, 500)
    counter = 1

    valid_images = []
    for o in options:
        image_path = os.path.join (CACHE_LOCATION, "alternative-" + str(len(valid_images)))
        valid_images.append (image_path)
        if (len(valid_images) > 10):
            break
    print valid_images


