#ifndef ALARM_H
#define ALARM_H

#include <alarmd/libalarm.h>

static cookie_t add_alarm(void) {

    alarm_event_t *newEvent = 0;
    alarm_action_t *act = 0;
    cookie_t resultCookie;

    newEvent = alarm_event_create();
    alarm_event_set_alarm_appid(newEvent, "cutetube");
    alarm_event_set_title(newEvent, "eventfeed");

    newEvent->recur_secs = 1800;
    newEvent->recur_count = -1;
    newEvent->alarm_time = (time_t) time(NULL) + 10;
    newEvent->flags = ALARM_EVENT_CONNECTED;

    act = alarm_event_add_actions(newEvent, 1);
    act->flags = ALARM_ACTION_WHEN_TRIGGERED | ALARM_ACTION_DBUS_USE_ACTIVATION | ALARM_ACTION_TYPE_DBUS;

    alarm_action_set_dbus_interface(act, "com.maemo.cuteTubeEvents");
    alarm_action_set_dbus_service(act, "com.maemo.cuteTubeEvents");
    alarm_action_set_dbus_path(act, "/");
    alarm_action_set_dbus_name(act, "startSync");

    resultCookie = alarmd_event_add(newEvent);
    alarm_event_delete(newEvent);
    act = 0;
    newEvent = 0;

    return resultCookie;
}

static bool delete_alarm(cookie_t cookie) {
    return alarmd_event_del(cookie) != -1;
}

#endif // ALARM_H
