#include "userlistdelegate.h"
#include "../base/userlistmodel.h"
#include <QApplication>
#include <QPainter>

UserListDelegate::UserListDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void UserListDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }
    else {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundNormal.png"));
    }

    QRect imageRect = option.rect;
    imageRect.moveTopLeft(QPoint(imageRect.left() + 8, imageRect.top() + 8));
    imageRect.setSize(QSize(64, 64));

    QImage image = index.data(UserListModel::AvatarRole).value<QImage>();

    if (!image.isNull()) {
        painter->drawImage(imageRect, image);
    }

    QRect textRect = option.rect;
    textRect.setTopLeft(QPoint(imageRect.right() + 8, imageRect.top()));
    textRect.setRight(textRect.right() - 8);
    textRect.setHeight(64);

    painter->drawText(textRect, Qt::TextWordWrap | Qt::AlignVCenter, index.data(UserListModel::UsernameRole).toString());
}

QSize UserListDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index)

    return QSize(option.rect.width(), 80);
}
