#include "screen.h"
#include <QDBusConnection>

Screen* Screen::self = 0;

Screen::Screen(QObject *parent) :
    QObject(parent)
{
    if (!self) {
        self = this;
    }

    QDBusConnection::systemBus().connect("",
                                         "/com/nokia/mce/signal",
                                         "com.nokia.mce.signal",
                                         "tklock_mode_ind",
                                         this,
                                         SLOT(onScreenLockStateChanged(QString)));
}

Screen::~Screen() {}

Screen* Screen::instance() {
    return !self ? new Screen : self;
}

void Screen::onScreenLockStateChanged(const QString &state) {
    if (state == "locked") {
        emit screenLockStateChanged(true);
    }
    else if (state == "unlocked") {
        emit screenLockStateChanged(false);
    }
}
