#ifndef PROFILETAB_H
#define PROFILETAB_H

#include "abstracttab.h"
#include "../base/useritem.h"

class SeparatorLabel;
class AvatarLabel;
class ScrollArea;
class QLabel;
class QPushButton;
class QGridLayout;

class ProfileTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit ProfileTab(const QString &userId, QWidget *parent = 0);
    explicit ProfileTab(QSharedPointer<UserItem> user, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void setUser(QSharedPointer<UserItem> user);
    void setAvatar();
    void onProfileError();
    void toggleFollowing();
    void onFollowedChanged(bool followd);

private:
    QSharedPointer<UserItem> m_user;
    AvatarLabel *m_avatar;
    QLabel *m_channelLabel;
    QLabel *m_tracksLabel;
    QLabel *m_playlistsLabel;
    QLabel *m_followersLabel;
    QLabel *m_fullnameLabel;
    QLabel *m_locationLabel;
    QLabel *m_bandnameLabel;
    QLabel *m_websiteLabel;
    QLabel *m_descriptionLabel;
    QLabel *m_noProfileLabel;
    QPushButton *m_followingButton;
    ScrollArea *m_scrollArea;
    QGridLayout *m_grid;
};

#endif // PROFILETAB_H
