#ifndef MYCHANNELWINDOW_H
#define MYCHANNELWINDOW_H

#include "stackedwindow.h"

class ProfileTab;
class TrackListTab;
class PlaylistListTab;
class GroupListTab;
class UserListTab;
class QStackedWidget;
class QActionGroup;
class QMenu;

class MyChannelWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit MyChannelWindow(QWidget *parent);

private:
    void clearMenuActions();

private slots:
    void showProfile();
    void showUploads();
    void showFavourites();
    void showPlaylists();
    void showGroups();
    void showFollowings();

private:
    QMenu *m_menu;
    QActionGroup *m_actionGroup;
    QAction *m_profileAction;
    QAction *m_uploadsAction;
    QAction *m_favouritesAction;
    QAction *m_playlistsAction;
    QAction *m_groupsAction;
    QAction *m_followingsAction;
    QStackedWidget *m_tabWidget;
    ProfileTab *m_profileTab;
    TrackListTab *m_uploadsTab;
    TrackListTab *m_favouritesTab;
    PlaylistListTab *m_playlistsTab;
    GroupListTab *m_groupsTab;
    UserListTab *m_followingsTab;
};

#endif // MYCHANNELWINDOW_H
