#include "archiveplaylistdelegate.h"
#include "../base/playlistlistmodel.h"
#include <QPainter>
#include <QMaemo5Style>
#include <QStaticText>

ArchivePlaylistDelegate::ArchivePlaylistDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void ArchivePlaylistDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    painter->save();

    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }
    else {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundNormal.png"));
    }

    QRect iconRect = option.rect;
    iconRect.setSize(QSize(64, 64));
    iconRect.moveTopLeft(QPoint(iconRect.left() + 8, iconRect.top() + 8));

    QImage thumbnail = index.data(PlaylistListModel::ThumbnailRole).value<QImage>();

    if (thumbnail.isNull()) {
        thumbnail = QImage("/usr/share/icons/hicolor/64x64/hildon/mediaplayer_default_album.png");
    }

    painter->drawImage(iconRect, thumbnail);

    QRect textRect = option.rect;
    textRect.setTopLeft(QPoint(textRect.left() + 80, textRect.top() + 8));
    textRect.setHeight(32);
    textRect.setRight(textRect.right() - 8);

    QStaticText titleText(index.data(PlaylistListModel::TitleRole).toString());
    QTextOption textOption;
    textOption.setWrapMode(QTextOption::NoWrap);
    titleText.setTextOption(textOption);
    titleText.setTextWidth(textRect.width());

    painter->setClipRect(textRect);
    painter->drawStaticText(textRect.topLeft(), titleText);

    textRect.moveTop(textRect.bottom());

    QFont smallFont;
    smallFont.setPixelSize(20);

    painter->setClipRect(textRect);
    painter->setFont(smallFont);
    painter->setPen(QMaemo5Style::standardColor("SecondaryTextColor"));
    painter->drawText(textRect, Qt::AlignBottom | Qt::TextSingleLine, QString("%1 - %2").arg(index.data(PlaylistListModel::DateRole).toString()).arg(index.data(PlaylistListModel::ArtistRole).toString()));
    painter->restore();
}

QSize ArchivePlaylistDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index)

    return QSize(option.rect.width(), 80);
}
