#include "userlistdelegate.h"
#include "../base/userlistmodel.h"
#include <QPainter>
#include <QApplication>

UserListDelegate::UserListDelegate(QObject *parent) :
    ListDelegate(parent)
{
}

void UserListDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    ListDelegate::paint(painter, option, index);

    QRect iconRect = option.rect;
    iconRect.setSize(QSize(64, 64));
    iconRect.moveTopLeft(QPoint(iconRect.left() + 8, iconRect.top() + (option.rect.height() / 2 - iconRect.height() / 2)));

    QImage thumbnail = index.data(UserListModel::AvatarRole).value<QImage>();

    if (thumbnail.isNull()) {
        thumbnail = QImage("/usr/share/icons/hicolor/64x64/hildon/qgn_addr_icon_avatar.png");
    }

    painter->drawImage(iconRect, thumbnail);

    QRect textRect = option.rect;
    textRect.setLeft(textRect.left() + 64);
    textRect.setRight(textRect.right() - 8);

    painter->drawText(textRect, Qt::AlignVCenter, index.data(UserListModel::UsernameRole).toString());
}
