#ifndef TOOLBAR_H
#define TOOLBAR_H

#include <QToolBar>
#include <QAbstractButton>

class QButtonGroup;

class Tab : public QAbstractButton
{
    Q_OBJECT

public:
    explicit Tab(QWidget *parent = 0);
    ~Tab();

protected:
    void paintEvent(QPaintEvent *event);
};

class ToolBar : public QToolBar
{
    Q_OBJECT

public:
    explicit ToolBar(QWidget *parent = 0);
    ~ToolBar();

    void setTabsEnabled(bool enabled);
    bool tabsEnabled() const;

    int currentTab() const;
    void setCurrentTab(int index);

protected:
    void paintEvent(QPaintEvent *event);
    
signals:
    void currentTabChanged(int index);

private:
    Tab *m_leftTab;
    Tab *m_rightTab;
    QButtonGroup *m_tabGroup;
    bool m_tabsEnabled;
};

#endif // TOOLBAR_H
