#include "nowplayingwindow.h"
#include "nowplayinglisttab.h"
#include "nowplayingcurrenttab.h"
#include "nowplayingbutton.h"
#include <QLabel>
#include <QStackedWidget>
#include <QGridLayout>
#include <QButtonGroup>

NowPlayingWindow::NowPlayingWindow(QWidget *parent) :
    QWidget(parent),
    m_listTab(new NowPlayingListTab(this)),
    m_currentTab(0),
    m_listButton(new NowPlayingButton(NowPlayingButton::List, this)),
    m_currentButton(new NowPlayingButton(NowPlayingButton::Current, this)),
    m_buttonGroup(new QButtonGroup(this)),
    m_titleLabel(new QLabel(m_listTab->windowTitle(), this)),
    m_stack(new QStackedWidget(this)),
    m_grid(new QGridLayout(this))
{
    this->setWindowTitle(tr("Now playing"));

    m_stack->addWidget(m_listTab);

    m_titleLabel->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Preferred);
    m_titleLabel->setAlignment(Qt::AlignTop);

    m_listButton->setCheckable(true);
    m_currentButton->setCheckable(true);

    m_listButton->setChecked(true);

    m_buttonGroup->addButton(m_listButton, 0);
    m_buttonGroup->addButton(m_currentButton, 1);
    m_buttonGroup->setExclusive(true);

    m_grid->addWidget(m_titleLabel, 0, 0);
    m_grid->addWidget(m_listButton, 0, 1, 1, 1, Qt::AlignRight);
    m_grid->addWidget(m_currentButton, 0, 2, 1, 1, Qt::AlignRight);
    m_grid->addWidget(m_stack, 1, 0, 1, 3);

    this->connect(m_buttonGroup, SIGNAL(buttonClicked(int)), this, SLOT(onTabButtonClicked(int)));
}

NowPlayingWindow::~NowPlayingWindow() {}

void NowPlayingWindow::onTabButtonClicked(int buttonId) {
    switch (buttonId) {
    case 1:
        this->showNowPlayingTab();
        return;
    default:
        this->showListTab();
    }
}

void NowPlayingWindow::showListTab() {
    m_stack->setCurrentWidget(m_listTab);
    m_titleLabel->setText(m_listTab->windowTitle());
}

void NowPlayingWindow::showNowPlayingTab() {
    if (!m_currentTab) {
        m_currentTab = new NowPlayingCurrentTab(this);
        m_stack->addWidget(m_currentTab);
    }

    m_stack->setCurrentWidget(m_currentTab);
    m_titleLabel->setText(m_currentTab->windowTitle());
}
