#ifndef MYCHANNELWINDOW_H
#define MYCHANNELWINDOW_H

#include "../base/useritem.h"
#include <QWidget>
#include <QSharedPointer>

class UserProfileWindow;
class TrackListWindow;
class PlaylistListWindow;
class GroupListWindow;
class UserListWindow;
class QTabBar;
class QStackedWidget;
class QVBoxLayout;

class MyChannelWindow : public QWidget
{
    Q_OBJECT

public:
    explicit MyChannelWindow(QWidget *parent = 0);
    ~MyChannelWindow();

protected:
    void keyPressEvent(QKeyEvent *event);

private:
    void showProfile();
    void showTracks();
    void showFavourites();
    void showPlaylists();
    void showGroups();
    void showFollowings();

private slots:
    void onCurrentTabChanged(int index);

private:
    QString m_userId;
    UserProfileWindow *m_profileTab;
    TrackListWindow *m_tracksTab;
    TrackListWindow *m_favouritesTab;
    PlaylistListWindow *m_playlistsTab;
    GroupListWindow *m_groupsTab;
    UserListWindow *m_followingsTab;
    QTabBar *m_tabBar;
    QStackedWidget *m_stack;
    QVBoxLayout *m_vbox;
};

#endif // MYCHANNELWINDOW_H
