#include "grouplistdelegate.h"
#include "../base/grouplistmodel.h"
#include <QPainter>
#include <QApplication>

GroupListDelegate::GroupListDelegate(QObject *parent) :
    ListDelegate(parent)
{
}

void GroupListDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    ListDelegate::paint(painter, option, index);

    painter->save();

    QRect iconRect = option.rect;
    iconRect.setSize(QSize(64, 64));
    iconRect.moveTopLeft(QPoint(iconRect.left() + 8, iconRect.top() + (option.rect.height() / 2 - iconRect.height() / 2)));

    QImage thumbnail = index.data(GroupListModel::ThumbnailRole).value<QImage>();

    if (thumbnail.isNull()) {
        thumbnail = QImage("/usr/share/icons/hicolor/scalable/hildon/qgn_list_gene_music_file.png");
    }

    painter->drawImage(iconRect, thumbnail);

    QRect textRect = option.rect;
    textRect.setTopLeft(QPoint(textRect.left() + 80, textRect.top() + 5));
    textRect.setRight(textRect.right() - 8);
    textRect.setBottom(textRect.bottom() - 5);

    painter->setClipRect(textRect);
    painter->drawText(textRect, Qt::AlignTop, index.data(GroupListModel::TitleRole).toString());

    painter->setPen(QApplication::palette().color(QPalette::Mid));
    painter->setClipRect(textRect);
    painter->drawText(textRect, Qt::AlignBottom, QString("%1 - %2").arg(index.data(GroupListModel::DateRole).toString()).arg(index.data(GroupListModel::ArtistRole).toString()));
    painter->restore();
}
