#include "exploredialog.h"
#include "../base/exploremodel.h"
#include <QListView>
#include <QDialogButtonBox>
#include <QVBoxLayout>

ExploreDialog::ExploreDialog(QWidget *parent) :
    QDialog(parent),
    m_model(new ExploreModel(this)),
    m_view(new QListView(this)),
    m_buttonBox(new QDialogButtonBox(QDialogButtonBox::Cancel | QDialogButtonBox::Ok, Qt::Horizontal, this)),
    m_vbox(new QVBoxLayout(this))
{
    this->setWindowTitle(tr("Explore"));
    this->setAttribute(Qt::WA_DeleteOnClose);

    m_view->setModel(m_model);
    m_view->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    m_view->setEditTriggers(QListView::NoEditTriggers);

    m_vbox->addWidget(m_view);
    m_vbox->addWidget(m_buttonBox);

    this->connect(m_view, SIGNAL(activated(QModelIndex)), this, SLOT(onListItemActivated(QModelIndex)));
    this->connect(m_buttonBox, SIGNAL(accepted()), this, SLOT(accept()));
    this->connect(m_buttonBox, SIGNAL(rejected()), this, SLOT(reject()));
}

ExploreDialog::~ExploreDialog() {}

void ExploreDialog::accept() {
    if (m_view->currentIndex().isValid()) {
        emit categoryChosen(static_cast<Queries::QueryType>(m_view->currentIndex().data(ExploreModel::TypeRole).toInt()),
                            m_view->currentIndex().data(ExploreModel::NameRole).toString(),
                            m_view->currentIndex().data(ExploreModel::FeedRole).toUrl());
    }

    QDialog::accept();
}

void ExploreDialog::onListItemActivated(const QModelIndex &index) {
    if (index.isValid()) {
        this->accept();
    }
}
