#include "commentdialog.h"
#include "../base/soundcloud.h"
#include <QPlainTextEdit>
#include <QPushButton>
#include <QCheckBox>
#include <QDialogButtonBox>
#include <QVBoxLayout>
#include <QLabel>
#include <QDateTime>

CommentDialog::CommentDialog(QSharedPointer<TrackItem> track, QWidget *parent) :
    QDialog(parent),
    m_track(track),
    m_timestamp(0),
    m_commentLabel(new QLabel(tr("Your comment"), this)),
    m_commentEdit(new QPlainTextEdit(this)),
    m_timestampCheckbox(new QCheckBox(tr("Add timestamp"), this)),
    m_buttonBox(new QDialogButtonBox(QDialogButtonBox::Cancel | QDialogButtonBox::Ok, Qt::Horizontal, this)),
    m_vbox(new QVBoxLayout(this))
{
    this->setWindowTitle(tr("Add comment"));
    this->setAttribute(Qt::WA_DeleteOnClose);

    m_commentEdit->setMaximumHeight(100);

    m_buttonBox->button(QDialogButtonBox::Ok)->setEnabled(false);

    m_vbox->addWidget(m_commentLabel);
    m_vbox->addWidget(m_commentEdit);
    m_vbox->addWidget(m_timestampCheckbox);
    m_vbox->addWidget(m_buttonBox);

    this->connect(m_commentEdit, SIGNAL(textChanged()), this, SLOT(onCommentTextChanged()));
    this->connect(m_buttonBox, SIGNAL(accepted()), this, SLOT(submitComment()));
    this->connect(m_buttonBox, SIGNAL(rejected()), this, SLOT(reject()));
}

CommentDialog::~CommentDialog() {}

void CommentDialog::onCommentTextChanged() {
    m_buttonBox->button(QDialogButtonBox::Ok)->setEnabled(!m_commentEdit->toPlainText().isEmpty());
}

void CommentDialog::submitComment() {
    SoundCloud::instance()->addComment(m_track.data()->id(), m_commentEdit->toPlainText(), m_timestampCheckbox->isChecked() ? m_timestamp : 0);
    this->accept();
}
