#ifndef NOTIFICATIONS_H
#define NOTIFICATIONS_H

#include <QObject>

#if (!defined (QML_USER_INTERFACE)) && (defined (Q_WS_MAEMO_5))
class QProgressDialog;
#endif

class Notifications : public QObject
{
    Q_OBJECT

public:
    explicit Notifications(QObject *parent = 0);
#if (defined (Q_WS_MAEMO_5) || (defined (Q_WS_MAEMO_4)))
    static void showAlert(const QString &message);
    static void showInfo(const QString &message);
    static void showError(const QString &message);
#ifdef Q_WS_MAEMO_5
    static void toggleBusy(bool busy);
#endif
#endif
    static Notifications* instance();
        
public slots:
    void onAlert(const QString &message);
    void onInfo(const QString &message);
    void onError(const QString &message);
    void showProgressDialog(const QString &message, int numberOfOperations);
    void updateProgressDialog(int progress);
#ifndef Q_WS_MAEMO_4
    void cancelProgressDialog();
#endif

signals:
    void alert(const QString &message);
    void info(const QString &message);
    void error(const QString &message);
    void busy(const QString &message, int numberOfOperations);
    void busyProgressChanged(int progress);
#ifdef QML_USER_INTERFACE
    void canceled();
#endif

private:
    static Notifications* self;
#if (!defined (QML_USER_INTERFACE)) && (defined (Q_WS_MAEMO_5))
    QProgressDialog *m_progressDialog;
#endif
};

#endif // NOTIFICATIONS_H
