#ifndef USERLISTTAB_H
#define USERLISTTAB_H

#include "abstracttab.h"

class UserListModel;
class ListView;
class QLabel;
class QGridLayout;
class QModelIndex;
class QUrl;

class UserListTab : public AbstractTab
{
    Q_OBJECT
public:
    explicit UserListTab(QWidget *parent = 0);
    void setUserFeed(const QUrl &feed);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);

private:
    UserListModel *m_model;
    ListView *m_listView;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // USERLISTTAB_H
