#include "trackselectionwindow.h"
#include "trackselectiondelegate.h"
#include "listview.h"
#include <QMaemo5EditBar>
#include <QPushButton>
#include <QVBoxLayout>
#include <QAbstractItemModel>

TrackSelectionWindow::TrackSelectionWindow(QAbstractItemModel *model, const QString &text, const char* slot, QWidget *parent) :
    QWidget(parent),
    m_model(model),
    m_listView(new ListView(this)),
    m_editBar(new QMaemo5EditBar(tr("Select tracks"), this)),
    m_acceptButton(new QPushButton(text, this)),
    m_vbox(new QVBoxLayout(this))
{
    this->setWindowFlags(Qt::Window);
    this->setWindowState(Qt::WindowFullScreen);
    this->setAttribute(Qt::WA_Maemo5StackedWindow, true);
    this->setAttribute(Qt::WA_DeleteOnClose, true);

    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new TrackSelectionDelegate(m_listView));

    m_editBar->addButton(m_acceptButton);
    m_vbox->setContentsMargins(0, 0, 0, 0);
    m_vbox->setSpacing(0);
    m_vbox->addWidget(m_editBar);
    m_vbox->addWidget(m_listView);

    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_acceptButton, SIGNAL(clicked()), this, SLOT(onButtonClicked()));
    this->connect(this, SIGNAL(accepted()), this, slot);
}

TrackSelectionWindow::~TrackSelectionWindow() {
    QMetaObject::invokeMethod(m_model, "selectNone");
}

void TrackSelectionWindow::positionAtIndex(const QModelIndex &index) {
    m_listView->scrollTo(index, QListView::PositionAtTop);
}

void TrackSelectionWindow::onItemClicked(const QModelIndex &index) {
    QMetaObject::invokeMethod(m_model, "toggleSelected", Q_ARG(int, index.row()));
}

void TrackSelectionWindow::onButtonClicked() {
    emit accepted();
}

void TrackSelectionWindow::addTracksToFavourites() {
    QMetaObject::invokeMethod(m_model, "addSelectedTracksToFavourites");
    this->close();
}

void TrackSelectionWindow::deleteTracksFromFavourites() {
    QMetaObject::invokeMethod(m_model, "deleteSelectedTracksToFavourites");
    this->close();
}

void TrackSelectionWindow::addTrackDownloads() {
    QMetaObject::invokeMethod(m_model, "downloadSelectedTracks");
    this->close();
}

void TrackSelectionWindow::queueTracks() {
    QMetaObject::invokeMethod(m_model, "queueSelectedTracks");
    this->close();
}

void TrackSelectionWindow::deleteTracks() {
    QMetaObject::invokeMethod(m_model, "deleteSelectedTracks");
    this->close();
}
