#include "thumbnaillabel.h"
#include "../base/utils.h"
#include <QMouseEvent>
#include <QPaintEvent>
#include <QPainter>
#include <QImage>
#include <QtCore/qmath.h>

ThumbnailLabel::ThumbnailLabel(QWidget *parent) :
    QWidget(parent),
    m_interactive(true),
    m_pressed(false)
{
}

void ThumbnailLabel::setImage(const QImage &image) {
    m_image = image;
    this->update();
}

void ThumbnailLabel::mousePressEvent(QMouseEvent *event) {
    if (this->interactive()) {
        event->accept();
        m_pressed = true;
        this->update();
    }
    else {
        event->ignore();
    }
}

void ThumbnailLabel::mouseReleaseEvent(QMouseEvent *event) {
    if ((this->interactive()) && (this->rect().contains(event->pos()))) {
        event->accept();
        m_pressed = false;
        this->update();
        emit clicked();
    }
    else {
        event->ignore();
    }
}

void ThumbnailLabel::leaveEvent(QEvent *event) {
    event->accept();
    m_pressed = false;
    this->update();
}

void ThumbnailLabel::paintEvent(QPaintEvent *event) {
    QPainter painter(this);

    if (m_pressed) {
        painter.setOpacity(0.5);
    }

    if (!this->image().isNull()) {
        painter.drawImage(this->rect(), this->image());
    }

    event->accept();
}
