#ifndef DAILYMOTIONCATEGORIESDIALOG_H
#define DAILYMOTIONCATEGORIESDIALOG_H

#include "abstractdialog.h"
#include "../base/enums.h"

class ExploreModel;
class ListView;
class QModelIndex;

class ExploreDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit ExploreDialog(QWidget *parent = 0);

private slots:
    void onCategoryChosen(const QModelIndex &index);

signals:
    void categoryChosen(Queries::QueryType type, const QString &title, const QUrl &feed);

private:
    ExploreModel *m_model;
    ListView *m_view;
};

#endif // DAILYMOTIONCATEGORIESDIALOG_H
