#include "homescreenmodel.h"
#include <qplatformdefs.h>

HomescreenModel::HomescreenModel(QObject *parent) :
    QAbstractListModel(parent)
{
    QHash<int, QByteArray> roles;
    roles[NameRole] = "name";
    roles[IconSourceRole] = "iconSource";
    this->setRoleNames(roles);

    m_list.append(QPair<QString, QString>(tr("You"), "images/you.png"));
    m_list.append(QPair<QString, QString>(tr("Dashboard"), "images/dashboard.png"));
    m_list.append(QPair<QString, QString>(tr("Explore"), "images/explore.png"));
    m_list.append(QPair<QString, QString>(tr("Search"), "images/search.png"));
    m_list.append(QPair<QString, QString>(tr("Queue"), "images/queue.png"));
#ifndef MEEGO_EDITION_HARMATTAN
    m_list.append(QPair<QString, QString>(tr("Transfers"), "images/transfers.png"));
#endif
    m_list.append(QPair<QString, QString>(tr("Archive"), "images/archive.png"));
    m_list.append(QPair<QString, QString>(tr("Settings"), "images/settings.png"));
    m_list.append(QPair<QString, QString>(tr("Accounts"), "images/accounts.png"));
#ifdef MEEGO_EDITION_HARMATTAN
    m_list.append(QPair<QString, QString>(tr("About"), "images/about.png"));
#endif
}

int HomescreenModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent)

    return m_list.size();
}

QVariant HomescreenModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case NameRole:
        return m_list.at(index.row()).first;
    case IconSourceRole:
        return m_list.at(index.row()).second;
    default:
        return QVariant();
    }
}

QVariant HomescreenModel::data(int row, const QByteArray &role) const {
    return this->data(this->index(row), this->roleNames().key(role));
}
