#ifndef EVENT_H
#define EVENT_H

#include "enums.h"
#include <QUrl>
#include <QVariantMap>

class Event
{

public:
    explicit Event();
    explicit Event(const QVariantMap &activity);
    ~Event() {}
    inline QString id() const { return m_id; }
    inline void setId(const QString &id) { m_id = id; }
    inline Activities::ActivityType activityType() const { return m_type; }
    inline void setActivityType(Activities::ActivityType type) { m_type = type; }
    inline QString activityTypeString() const { return m_typeString; }
    inline void setActivityTypeString(const QString &type) { m_typeString = type; }
    inline QString title() const { return m_title; }
    inline void setTitle(const QString &title) { m_title = title; }
    inline QString artist() const { return m_artist; }
    inline void setArtist(const QString &artist) { m_artist = artist; }
    inline QString artistId() const { return m_artistId; }
    inline void setArtistId(const QString &id) { m_artistId = id; }
    inline QUrl artistAvatarUrl() const { return m_artistAvatarUrl; }
    inline void setArtistAvatarUrl(const QUrl &url) { m_artistAvatarUrl = url; }
    inline QString body() const { return m_body; }
    inline void setBody(const QString &body) { m_body = body; }
    inline qint64 date() const { return m_date; }
    inline void setDate(qint64 date) { m_date = date; }
    inline QUrl thumbnailUrl() const { return m_thumbnailUrl; }
    inline void setThumbnailUrl(const QUrl &url) { m_thumbnailUrl = url; }

private:
    void loadTrack(const QVariantMap &track);
    void loadPlaylist(const QVariantMap &playlist);
    void loadTrackSharing(const QVariantMap &track);
    void loadComment(const QVariantMap &comment);
    void loadFavourite(const QVariantMap &favourite);
    
private:
    QString m_id;
    Activities::ActivityType m_type;
    QString m_typeString;
    QString m_title;
    QString m_artist;
    QString m_artistId;
    QUrl m_artistAvatarUrl;
    QString m_body;
    qint64 m_date;
    QUrl m_thumbnailUrl;
};

#endif // ACTIVITYITEM_H
