#ifndef SEARCHTYPESELECTOR_H
#define SEARCHTYPESELECTOR_H

#include "../base/enums.h"
#include <QMaemo5ValueButton>

class SearchTypeModel;
class QMaemo5ListPickSelector;

class SearchTypeSelector : public QMaemo5ValueButton
{
    Q_OBJECT

public:
    explicit SearchTypeSelector(const QString &text, QWidget *parent = 0);
    void setValue(Queries::QueryType value);
    Queries::QueryType currentValue();

private slots:
    void onSelected();

signals:
    void valueChanged(Queries::QueryType value);

private:
    SearchTypeModel *m_model;
    QMaemo5ListPickSelector *m_selector;
};

#endif // SEARCHTYPESELECTOR_H
