#ifndef GROUPLISTWINDOW_H
#define GROUPLISTWINDOW_H

#include "stackedwindow.h"
#include "../base/groupitem.h"

class GroupListModel;
class ListView;
class QLabel;
class QModelIndex;

class GroupListWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit GroupListWindow(QWidget *parent);
    void setGroupFeed(const QUrl &feed);
    void search(const QString &query, Queries::QueryOrder order);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);
    void showGroup(QSharedPointer<GroupItem> group);

private:
    ListView *m_listView;
    GroupListModel *m_model;
    QLabel *m_noResultsLabel;
};

#endif // GROUPLISTWINDOW_H
