#ifndef USERLISTTAB_H
#define USERLISTTAB_H

#include "abstracttab.h"

class UserListModel;
class ListView;
class QLabel;
class QGridLayout;
class QAction;
class QModelIndex;
class QUrl;

class UserListTab : public AbstractTab
{
    Q_OBJECT
public:
    explicit UserListTab(const QString &userId, QWidget *parent = 0);
    void setUserFeed(const QUrl &feed);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);
    void showUserChannel(const QString &userId);
    void showFollowingTracks();

private:
    QString m_userId;
    UserListModel *m_model;
    ListView *m_listView;
    QAction *m_tracksAction;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // USERLISTTAB_H
