#include "trackselectiondelegate.h"
#include "../base/tracklistmodel.h"
#include <QPainter>
#include <QMaemo5Style>

TrackSelectionDelegate::TrackSelectionDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void TrackSelectionDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    painter->save();

    if (((option.state) & (QStyle::State_Selected)) || index.data(TrackListModel::SelectedRole).toBool()) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }
    else {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundNormal.png"));
    }

    QRect iconRect = option.rect;
    iconRect.setSize(QSize(64, 64));
    iconRect.moveTopLeft(QPoint(iconRect.left() + 8, iconRect.top() + 8));

    QImage thumbnail = index.data(TrackListModel::ThumbnailRole).value<QImage>();

    if (thumbnail.isNull()) {
        thumbnail = QImage("/usr/share/icons/hicolor/64x64/hildon/mediaplayer_default_album.png");
    }

    painter->drawImage(iconRect, thumbnail);

    if (index.data(TrackListModel::SelectedRole).toBool()) {
        iconRect.moveTopRight(QPoint(option.rect.right(), iconRect.top() + 8));
        iconRect.setSize(QSize(48, 48));

        painter->drawImage(iconRect, QImage("/usr/share/icons/hicolor/48x48/hildon/widgets_tickmark_grid.png"));
    }

    QRect textRect = option.rect;
    textRect.moveTopLeft(QPoint(textRect.left() + 80, textRect.top() + 8));
    textRect.setHeight(32);
    textRect.setRight(index.data(TrackListModel::SelectedRole).toBool() ? textRect.right() - 56 : textRect.right() - 8);

    painter->setClipRect(textRect);
    painter->drawText(textRect, Qt::AlignTop, index.data(TrackListModel::TitleRole).toString());

    textRect.moveTop(textRect.bottom());

    painter->setPen(QMaemo5Style::standardColor("SecondaryTextColor"));
    painter->drawText(textRect, Qt::AlignBottom, QString("%1 - %2").arg(index.data(TrackListModel::DateRole).toString()).arg(index.data(TrackListModel::ArtistRole).toString()));
    painter->restore();
}

QSize TrackSelectionDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index)

    return QSize(option.rect.width(), 80);
}
