#ifndef PLAYBACKQUEUEWINDOW_H
#define PLAYBACKQUEUEWINDOW_H

#include "stackedwindow.h"
#include "../base/groupitem.h"
#include "../base/trackitem.h"

class ListView;
class QAction;
class QLabel;
class QModelIndex;

class PlaybackQueueWindow : public StackedWindow
{
    Q_OBJECT
public:
    explicit PlaybackQueueWindow(QWidget *parent);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void setMenuActions();
    void onCountChanged(int count);
    void addTracksToFavourites();
    void addTrackDownloads();
    void deleteTracksFromQueue();
    void showContextMenu(const QPoint &pos);
    void toggleFavourite();
    void addTrackDownload();
    void deleteTrackFromQueue();
    void onItemClicked(const QModelIndex &index);
    void showTrackInfo(QSharedPointer<TrackItem> track);
    void playTrack(const QModelIndex &index);

private:
    ListView *m_listView;
    QAction *m_addToFavouritesAction;
    QAction *m_deleteFromQueueAction;
    QAction *m_trackDownloadAction;
    QMenu *m_contextMenu;
    QAction *m_favouritesContextAction;
    QAction *m_deleteFromQueueContextAction;
    QAction *m_trackDownloadContextAction;
    QLabel *m_noResultsLabel;
};

#endif // PLAYBACKQUEUEWINDOW_H
