#include "nowplayingdelegate.h"
#include "../base/playbacklistmodel.h"
#include "../base/utils.h"
#include <QPainter>
#include <QMaemo5Style>

NowPlayingDelegate::NowPlayingDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void NowPlayingDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    painter->save();

    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }
    else {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundNormal.png"));
    }

    QRect textRect = option.rect;
    textRect.moveTopLeft(QPoint(textRect.left() + 8, textRect.top() + 8));
    textRect.setHeight(32);
    textRect.setRight(textRect.right() - 108);

    painter->setClipRect(textRect);
    painter->drawText(textRect, Qt::AlignTop, index.data(PlaybackListModel::TitleRole).toString());

    textRect.moveTop(textRect.bottom());

    QFont smallFont;
    smallFont.setPixelSize(20);

    painter->setFont(smallFont);
    painter->setPen(QMaemo5Style::standardColor("SecondaryTextColor"));
    painter->setClipRect(textRect);
    painter->drawText(textRect, Qt::AlignBottom, index.data(PlaybackListModel::ArtistRole).toString());
    painter->restore();

    textRect.moveBottom(textRect.top());
    textRect.moveLeft(textRect.right());
    textRect.setWidth(90);

    painter->drawText(textRect, Qt::AlignTop | Qt::AlignRight, Utils::durationFromMSecs(index.data(PlaybackListModel::DurationRole).toLongLong()));
}

QSize NowPlayingDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index)

    return QSize(option.rect.width(), 80);
}
