#include "mychannelwindow.h"
#include "../base/feedurls.h"
#include "profiletab.h"
#include "tracklisttab.h"
#include "playlistlisttab.h"
#include "grouplisttab.h"
#include "userlisttab.h"
#include <QStackedWidget>
#include <QActionGroup>
#include <QMenu>
#include <QMenuBar>

MyChannelWindow::MyChannelWindow(QWidget *parent) :
    StackedWindow(parent),
    m_menu(this->menuBar()->addMenu("")),
    m_actionGroup(new QActionGroup(this)),
    m_profileAction(new QAction("Pro", this)),
    m_uploadsAction(new QAction("Upl", this)),
    m_favouritesAction(new QAction("Fav", this)),
    m_playlistsAction(new QAction("Sets", this)),
    m_groupsAction(new QAction("Gro", this)),
    m_followingsAction(new QAction("Fol", this)),
    m_tabWidget(new QStackedWidget(this)),
    m_profileTab(new ProfileTab("me", m_tabWidget)),
    m_uploadsTab(0),
    m_favouritesTab(0),
    m_playlistsTab(0),
    m_groupsTab(0),
    m_followingsTab(0)
{
    this->setCentralWidget(m_tabWidget);

    m_profileAction->setCheckable(true);
    m_profileAction->setActionGroup(m_actionGroup);

    m_uploadsAction->setCheckable(true);
    m_uploadsAction->setActionGroup(m_actionGroup);

    m_favouritesAction->setCheckable(true);
    m_favouritesAction->setActionGroup(m_actionGroup);

    m_playlistsAction->setCheckable(true);
    m_playlistsAction->setActionGroup(m_actionGroup);

    m_groupsAction->setCheckable(true);
    m_groupsAction->setActionGroup(m_actionGroup);

    m_followingsAction->setCheckable(true);
    m_followingsAction->setActionGroup(m_actionGroup);

    m_menu->addAction(m_profileAction);
    m_menu->addAction(m_uploadsAction);
    m_menu->addAction(m_favouritesAction);
    m_menu->addAction(m_playlistsAction);
    m_menu->addAction(m_groupsAction);
    m_menu->addAction(m_followingsAction);

    m_profileAction->setChecked(true);

    m_tabWidget->setFrameStyle(QFrame::NoFrame);
    m_tabWidget->addWidget(m_profileTab);

    this->connect(m_profileAction, SIGNAL(triggered()), this, SLOT(showProfile()));
    this->connect(m_uploadsAction, SIGNAL(triggered()), this, SLOT(showUploads()));
    this->connect(m_favouritesAction, SIGNAL(triggered()), this, SLOT(showFavourites()));
    this->connect(m_playlistsAction, SIGNAL(triggered()), this, SLOT(showPlaylists()));
    this->connect(m_groupsAction, SIGNAL(triggered()), this, SLOT(showGroups()));
    this->connect(m_followingsAction, SIGNAL(triggered()), this, SLOT(showFollowings()));

    this->showProfile();
    this->onOrientationChanged();
}

void MyChannelWindow::clearMenuActions() {
    QList<QAction*> actions = this->menuBar()->actions();

    for (int i = 1; i < actions.size(); i++) {
        this->menuBar()->removeAction(actions.at(i));
    }
}

void MyChannelWindow::showProfile() {
    m_tabWidget->setCurrentWidget(m_profileTab);
    this->setWindowTitle(tr("Profile"));
    this->clearMenuActions();
}

void MyChannelWindow::showUploads() {
    if (!m_uploadsTab) {
        m_uploadsTab = new TrackListTab(this);
        m_uploadsTab->setTrackFeed(UPLOADS_FEED);
        m_tabWidget->addWidget(m_uploadsTab);
    }

    m_tabWidget->setCurrentWidget(m_uploadsTab);
    this->setWindowTitle(tr("Uploads"));
    this->clearMenuActions();
    this->menuBar()->addActions(m_uploadsTab->actions());
}

void MyChannelWindow::showFavourites() {
    if (!m_favouritesTab) {
        m_favouritesTab = new TrackListTab(this);
        m_favouritesTab->setTrackFeed(FAVOURITES_FEED);
        m_tabWidget->addWidget(m_favouritesTab);
    }

    m_tabWidget->setCurrentWidget(m_favouritesTab);
    this->setWindowTitle(tr("Favourites"));
    this->clearMenuActions();
    this->menuBar()->addActions(m_favouritesTab->actions());
}

void MyChannelWindow::showPlaylists() {
    if (!m_playlistsTab) {
        m_playlistsTab = new PlaylistListTab(this);
        m_playlistsTab->setPlaylistFeed(PLAYLISTS_FEED);
        m_tabWidget->addWidget(m_playlistsTab);
    }

    m_tabWidget->setCurrentWidget(m_playlistsTab);
    this->setWindowTitle(tr("Sets"));
    this->clearMenuActions();
    this->menuBar()->addActions(m_playlistsTab->actions());
}

void MyChannelWindow::showGroups() {
    if (!m_groupsTab) {
        m_groupsTab = new GroupListTab(this);
        m_groupsTab->setGroupFeed(GROUPS_FEED);
        m_tabWidget->addWidget(m_groupsTab);
    }

    m_tabWidget->setCurrentWidget(m_groupsTab);
    this->setWindowTitle(tr("Groups"));
    this->clearMenuActions();
}

void MyChannelWindow::showFollowings() {
    if (!m_followingsTab) {
        m_followingsTab = new UserListTab("me", this);
        m_followingsTab->setUserFeed(FOLLOWINGS_FEED);
        m_tabWidget->addWidget(m_followingsTab);
    }

    m_tabWidget->setCurrentWidget(m_followingsTab);
    this->setWindowTitle(tr("Followings"));
    this->clearMenuActions();
    this->menuBar()->addActions(m_followingsTab->actions());
}
