#ifndef CONNECTIONSDIALOG_H
#define CONNECTIONSDIALOG_H

#include "abstractdialog.h"
#include <QStyledItemDelegate>

class ListView;
class ConnectionListModel;
class QLabel;

class ConnectionsDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit ConnectionsDialog(QWidget *parent = 0);
    QStringList connections() const;
    QStringList connectionNames() const;

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);

signals:
    void connectionNamesChanged(const QStringList &names);
    
private:
    ConnectionListModel *m_model;
    ListView *m_view;
    QLabel *m_noResultsLabel;
};

class QPainter;

class ConnectionListDelegate : public QStyledItemDelegate
{
    Q_OBJECT

public:
    explicit ConnectionListDelegate(QObject *parent = 0);
    void paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const;
    QSize sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const;
};

#endif // CONNECTIONSDIALOG_H
