#include "archivewindow.h"
#include "archivetrackstab.h"
#include "archiveplayliststab.h"
#include <QActionGroup>
#include <QMenuBar>
#include <QMenu>
#include <QStackedWidget>

ArchiveWindow::ArchiveWindow(QWidget *parent) :
    StackedWindow(parent),
    m_menu(this->menuBar()->addMenu("")),
    m_actionGroup(new QActionGroup(this)),
    m_tracksAction(new QAction(tr("Tracks"), this)),
    m_playlistsAction(new QAction(tr("Sets"), this)),
    m_tracksTab(new ArchiveTracksTab(this)),
    m_playlistsTab(0),
    m_stack(new QStackedWidget(this))
{
    this->setWindowTitle(tr("Archive"));
    this->setCentralWidget(m_stack);

    m_tracksAction->setCheckable(true);
    m_tracksAction->setActionGroup(m_actionGroup);
    m_playlistsAction->setCheckable(true);
    m_playlistsAction->setActionGroup(m_actionGroup);

    m_menu->addAction(m_tracksAction);
    m_menu->addAction(m_playlistsAction);

    m_tracksAction->setChecked(true);

    m_stack->setFrameStyle(QFrame::NoFrame);
    m_stack->addWidget(m_tracksTab);

    this->connect(m_tracksAction, SIGNAL(triggered()), this, SLOT(showTracks()));
    this->connect(m_playlistsAction, SIGNAL(triggered()), this, SLOT(showPlaylists()));

    this->showTracks();
}

void ArchiveWindow::showTracks() {
    m_stack->setCurrentWidget(m_tracksTab);
    this->clearMenuActions();
    this->menuBar()->addActions(m_tracksTab->actions());
    this->setFocusProxy(m_tracksTab);
}

void ArchiveWindow::showPlaylists() {
    if (!m_playlistsTab) {
        m_playlistsTab = new ArchivePlaylistsTab(this);
        m_stack->addWidget(m_playlistsTab);
    }

    m_stack->setCurrentWidget(m_playlistsTab);
    this->clearMenuActions();
    this->setFocusProxy(m_playlistsTab);
}

void ArchiveWindow::clearMenuActions() {
    QList<QAction*> actions = this->menuBar()->actions();

    for (int i = 1; i < actions.size(); i++) {
        this->menuBar()->removeAction(actions.at(i));
    }
}
