#ifndef TRACKITEM_H
#define TRACKITEM_H

#include "enums.h"
#include <QObject>
#include <QVariantMap>
#include <QUrl>
#include <QStringList>

class TrackItem : public QObject
{
    Q_OBJECT

    Q_PROPERTY(QString id
               READ id
               CONSTANT)
    Q_PROPERTY(QString playlistId
               READ playlistId
               CONSTANT)
    Q_PROPERTY(QUrl url
               READ url
               CONSTANT)
    Q_PROPERTY(QUrl streamUrl
               READ streamUrl
               CONSTANT)
    Q_PROPERTY(QUrl downloadUrl
               READ downloadUrl
               CONSTANT)
    Q_PROPERTY(QString title
               READ title
               NOTIFY titleChanged)
    Q_PROPERTY(QString artist
               READ artist
               NOTIFY artistChanged)
    Q_PROPERTY(QString artistId
               READ artistId
               NOTIFY artistIdChanged)
    Q_PROPERTY(QUrl artistAvatarUrl
               READ artistAvatarUrl
               NOTIFY artistAvatarUrlChanged)
    Q_PROPERTY(QString description
               READ description
               NOTIFY descriptionChanged)
    Q_PROPERTY(int duration
               READ duration
               NOTIFY durationChanged)
    Q_PROPERTY(QString date
               READ date
               NOTIFY dateChanged)
    Q_PROPERTY(QString genre
               READ genre
               NOTIFY genreChanged)
    Q_PROPERTY(int trackNumber
               READ trackNumber
               NOTIFY trackNumberChanged)
    Q_PROPERTY(qint64 size
               READ size
               NOTIFY sizeChanged)
    Q_PROPERTY(int playCount
               READ playCount
               WRITE setPlayCount
               NOTIFY playCountChanged)
    Q_PROPERTY(QString lastPlayed
               READ lastPlayed
               WRITE setLastPlayed
               NOTIFY lastPlayedChanged)
    Q_PROPERTY(int downloadCount
               READ downloadCount
               WRITE setDownloadCount
               NOTIFY downloadCountChanged)
    Q_PROPERTY(QString format
               READ format
               NOTIFY formatChanged)
    Q_PROPERTY(int bpm
               READ bpm
               NOTIFY bpmChanged)
    Q_PROPERTY(QUrl thumbnailUrl
               READ thumbnailUrl
               NOTIFY thumbnailUrlChanged)
    Q_PROPERTY(QUrl largeThumbnailUrl
               READ largeThumbnailUrl
               NOTIFY largeThumbnailUrlChanged)
    Q_PROPERTY(bool favourite
               READ favourite
               NOTIFY favouriteChanged)
    Q_PROPERTY(bool downloadable
               READ downloadable
               CONSTANT)
    Q_PROPERTY(bool downloaded
               READ downloaded
               NOTIFY downloadedChanged)
    Q_PROPERTY(bool commentable
               READ commentable
               CONSTANT)
    Q_PROPERTY(bool isPrivate
               READ isPrivate
               NOTIFY isPrivateChanged)
    Q_PROPERTY(Services::AudioService service
               READ service
               NOTIFY serviceChanged)


public:
    explicit TrackItem(QObject *parent = 0);
    explicit TrackItem(TrackItem *track, QObject *parent = 0);
    explicit TrackItem(const QVariantMap &track, QObject *parent = 0);
    ~TrackItem() {}
    Q_INVOKABLE void loadTrack(TrackItem *track);
    inline QString id() const { return m_id; }
    inline void setId(const QString &id) { m_id = id; }
    inline QString playlistId() const { return m_playlistId; }
    inline void setPlaylistId(const QString &id) { m_playlistId = id; }
    inline QUrl url() const { return m_url; }
    inline void setUrl(const QUrl &url) { m_url = url; }
    inline QUrl streamUrl() const { return m_streamUrl; }
    inline void setStreamUrl(const QUrl &url) { m_streamUrl = url; }
    inline QUrl downloadUrl() const { return m_downloadUrl; }
    inline void setDownloadUrl(const QUrl &url) { m_downloadUrl = url; }
    inline QUrl embedUrl() const { return m_embedUrl; }
    inline void setEmbedUrl(const QUrl &url) { m_embedUrl = url; }
    inline QString title() const { return m_title; }
    inline void setTitle(const QString &title) { m_title = title; emit titleChanged(title); }
    inline QString artist() const { return m_artist; }
    inline void setArtist(const QString &artist) { m_artist = artist; emit artistChanged(artist); }
    inline QString artistId() const { return m_artistId; }
    inline void setArtistId(const QString &id) { m_artistId = id; emit artistIdChanged(id); }
    inline QUrl artistAvatarUrl() const { return m_artistAvatarUrl; }
    inline void setArtistAvatarUrl(const QUrl &url) { m_artistAvatarUrl = url; emit artistAvatarUrlChanged(url); }
    inline QString description() const { return m_description; }
    inline void setDescription(const QString &description) { m_description = description; emit descriptionChanged(description); }
    inline int duration() const { return m_duration; }
    inline void setDuration(int duration) { m_duration = duration; emit durationChanged(duration); }
    inline QString date() const { return m_date; }
    inline void setDate(const QString &date) { m_date = date; emit dateChanged(date); }
    inline QString genre() const { return m_genre; }
    inline void setGenre(const QString &genre) { m_genre = genre; emit genreChanged(genre); }
    inline int trackNumber() const { return m_trackNumber; }
    inline void setTrackNumber(int number) { m_trackNumber = number; emit trackNumberChanged(number); }
    inline qint64 size() const { return m_size; }
    inline void setSize(qint64 size) { m_size = size; emit sizeChanged(size); }
    inline QString format() const { return m_format; }
    inline void setFormat(const QString &format) { m_format = format; emit formatChanged(format); }
    inline int bpm() const { return m_bpm; }
    inline void setBpm(int bpm) { m_bpm = bpm; emit bpmChanged(bpm); }
    inline QStringList tags() const { return m_tags; }
    inline void setTags(const QStringList &tags) { m_tags = tags; emit tagsChanged(tags); }
    inline int playCount() const { return m_playCount; }
    inline void setPlayCount(int count) { m_playCount = count; emit playCountChanged(count); }
    inline QString lastPlayed() const { return m_lastPlayed; }
    inline void setLastPlayed(const QString &lastPlayed) { m_lastPlayed = lastPlayed; emit lastPlayedChanged(lastPlayed); }
    inline int downloadCount() const { return m_downloadCount; }
    inline void setDownloadCount(int count) { m_downloadCount = count; emit downloadCountChanged(count); }
    inline QUrl thumbnailUrl() const { return m_thumbUrl; }
    inline void setThumbnailUrl(const QUrl &url) { m_thumbUrl = url; emit thumbnailUrlChanged(url); }
    inline QUrl largeThumbnailUrl() const { return m_largeThumbUrl; }
    inline void setLargeThumbnailUrl(const QUrl &url) { m_largeThumbUrl = url; emit largeThumbnailUrlChanged(url); }
    inline QUrl waveformUrl() const { return m_waveformUrl; }
    inline void setWaveformUrl(const QUrl &url) { m_waveformUrl = url; emit waveformUrlChanged(url); }
    inline bool favourite() const { return m_favourite; }
    inline void setFavourite(bool isFavourite) { m_favourite = isFavourite; emit favouriteChanged(isFavourite); }
    inline bool downloadable() const { return m_downloadable; }
    inline void setDownloadable(bool downloadable) { m_downloadable = downloadable; }
    inline bool downloaded() const { return m_downloaded; }
    inline void setDownloaded(bool downloaded) { m_downloaded = downloaded; emit downloadedChanged(downloaded); }
    inline bool commentable() const { return m_commentable; }
    inline void setCommentable(bool commentable) { m_commentable = commentable; }
    inline bool isPrivate() const { return m_private; }
    inline void setPrivate(bool isPrivate) { m_private = isPrivate; emit isPrivateChanged(isPrivate); }
    inline Services::AudioService service() const { return m_service; }
    inline void setService(Services::AudioService service) { m_service = service; emit serviceChanged(service); }
    inline bool operator ==(TrackItem *other) { return other->id() == this->id(); }

private slots:
    void onFavouriteChanged(const QString &id, bool favourite);

signals:
    void titleChanged(const QString &title);
    void artistChanged(const QString &artist);
    void artistIdChanged(const QString &id);
    void artistAvatarUrlChanged(const QUrl &url);
    void descriptionChanged(const QString &description);
    void durationChanged(int duration);
    void dateChanged(const QString &date);
    void genreChanged(const QString &genre);
    void trackNumberChanged(int trackNumber);
    void sizeChanged(qint64 size);
    void tagsChanged(const QStringList &tags);
    void playCountChanged(int count);
    void lastPlayedChanged(const QString &lastPlayed);
    void formatChanged(const QString &format);
    void bpmChanged(int bpm);
    void downloadCountChanged(int count);
    void thumbnailUrlChanged(const QUrl &url);
    void largeThumbnailUrlChanged(const QUrl &url);
    void waveformUrlChanged(const QUrl &url);
    void favouriteChanged(bool favourite);
    void downloadedChanged(bool downloaded);
    void isPrivateChanged(bool isPrivate);
    void serviceChanged(Services::AudioService service);

private:
    QString m_id;
    QString m_playlistId;
    QUrl m_url;
    QUrl m_streamUrl;
    QUrl m_downloadUrl;
    QUrl m_embedUrl;
    QString m_title;
    QString m_artist;
    QString m_artistId;
    QUrl m_artistAvatarUrl;
    QString m_description;
    int m_duration;
    QString m_date;
    QString m_genre;
    int m_trackNumber;
    qint64 m_size;
    QStringList m_tags;
    int m_playCount;
    QString m_lastPlayed;
    int m_downloadCount;
    QString m_format;
    int m_bpm;
    QUrl m_thumbUrl;
    QUrl m_largeThumbUrl;
    QUrl m_waveformUrl;
    bool m_favourite;
    bool m_downloadable;
    bool m_downloaded;
    bool m_commentable;
    bool m_private;
    Services::AudioService m_service;
};

#endif // TRACKITEM_H
