#ifndef EXPLOREMODEL_H
#define EXPLOREMODEL_H

#include "enums.h"
#include <QAbstractListModel>
#include <QUrl>

typedef struct {
    Queries::QueryType type;
    QUrl feed;
    QString title;
} ExploreItem;

class ExploreModel : public QAbstractListModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    enum Roles {
        TitleRole = Qt::DisplayRole,
        TypeRole = Qt::UserRole + 1,
        FeedRole

    };

public:
    explicit ExploreModel(QObject *parent = 0);
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;

private:
    void addItem(Queries::QueryType type, const QUrl &feed, const QString &title);
    
signals:
    void countChanged(int count);
    
private:
    QList<ExploreItem> m_list;
};

#endif // EXPLOREMODEL_H
