#include "exploremodel.h"

ExploreModel::ExploreModel(QObject *parent) :
    QAbstractListModel(parent)
{
    QHash<int, QByteArray> roles;
    roles[TitleRole] = "title";
    roles[TypeRole] = "type";
    roles[FeedRole] = "feed";
    this->setRoleNames(roles);

    this->addItem(Queries::Tracks, QUrl("http://api.soundcloud.com/tracks.json?limit=30&order=created_at"), tr("Latest tracks"));
    this->addItem(Queries::Tracks, QUrl("http://api.soundcloud.com/tracks.json?limit=30&order=hotness"), tr("Hottest tracks"));
    this->addItem(Queries::Users, QUrl("http://api.soundcloud.com/users.json?limit=30"), tr("People"));
    this->addItem(Queries::Groups, QUrl("http://api.soundcloud.com/groups.json?limit=30"), tr("Groups"));

    emit countChanged(this->rowCount());
}

int ExploreModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent)

    return m_list.size();
}

QVariant ExploreModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case TitleRole:
        return m_list.at(index.row()).title;
    case TypeRole:
        return m_list.at(index.row()).type;
    case FeedRole:
        return m_list.at(index.row()).feed;
    default:
        return QVariant();
    }
}

QVariant ExploreModel::data(int row, const QByteArray &role) const {
    return this->data(this->index(row), this->roleNames().key(role));
}

void ExploreModel::addItem(Queries::QueryType type, const QUrl &feed, const QString &title) {
    ExploreItem item;
    item.type = type;
    item.feed = feed;
    item.title = title;

    this->beginInsertRows(QModelIndex(), this->rowCount(), this->rowCount());
    m_list.append(item);
    this->endInsertRows();
}
