#include "clipboardmonitor.h"
#include "settings.h"
#include <QApplication>
#include <QClipboard>
#include <QDebug>
#ifdef MEEGO_EDITION_HARMATTAN
#include <QTimer>
#endif

ClipboardMonitor* monitorInstance = 0;

ClipboardMonitor::ClipboardMonitor(QObject *parent) :
    QObject(parent)
  #ifdef MEEGO_EDITION_HARMATTAN
  ,m_timer(0)
  #endif
{
    if (!monitorInstance) {
        monitorInstance = this;
    }

    this->connect(QApplication::clipboard(), SIGNAL(dataChanged()), this, SLOT(onClipboardTextChanged()));
}

ClipboardMonitor* ClipboardMonitor::instance() {
    return monitorInstance;
}

void ClipboardMonitor::onClipboardTextChanged() {
#ifdef MEEGO_EDITION_HARMATTAN
    if ((m_timer) && (m_timer->isActive())) {
        // QClipboard::dataChanged() signal is emitted twice in Harmattan, so ignore the signal if the timer is still active.
        return;
    }
    else {
        if (!m_timer) {
            m_timer = new QTimer(this);
            m_timer->setInterval(3000);
            m_timer->setSingleShot(true);
        }

        m_timer->start();
    }
#endif
    if (QApplication::clipboard()->text().contains(QRegExp("http(s|)://(www.|)soundcloud.com/\\w+"))) {
        this->setClipboardUrl(QApplication::clipboard()->text());
    }
}

void ClipboardMonitor::setClipboardUrl(const QString &url) {
    qDebug() << "Clipboard url: " + url;
    m_clipboardUrl = url;
    emit clipboardUrlChanged(url);

    if (Settings::instance()->monitorClipboard()) {
        emit gotClipboardUrl(url);
    }
}
