#ifndef ArchivePlaylistModel_H
#define ArchivePlaylistModel_H

#include "playlistitem.h"
#include <QSharedPointer>
#include <QSortFilterProxyModel>

class PlaylistListModel;

class ArchivePlaylistModel : public QSortFilterProxyModel
{
    Q_OBJECT

    Q_PROPERTY(bool loading
               READ loading
               NOTIFY loadingChanged)
    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
    Q_PROPERTY(QString query
               READ query
               WRITE setQuery
               NOTIFY queryChanged)
#if (defined (QML_USER_INTERFACE) && (!defined (Q_WS_MAEMO_5)))
    Q_PROPERTY(QString highlightColor
               READ highlightColor
               WRITE setHighlightColor)
#endif

public:
    explicit ArchivePlaylistModel(QObject *parent = 0);
    ~ArchivePlaylistModel();
    inline bool loading() const { return m_loading; }
    inline QString query() const { return m_query; }
    QString regexMatch(QString str) const;
    QVariant data(const QModelIndex &index, int role) const;
    QVariant data(int row, const QByteArray &role) const;
    QSharedPointer<PlaylistItem> get(int row) const;
#ifdef QML_USER_INTERFACE
    Q_INVOKABLE PlaylistItem* getFromQML(int row) const;
#endif
#if (defined (QML_USER_INTERFACE) && (!defined (Q_WS_MAEMO_5)))
    inline QString highlightColor() const { return m_highlight; }
    inline void setHighlightColor(const QString &color) { m_highlight = color; }
#endif

public slots:
    void clear();
    void reset();
    void getPlaylists();
    void setQuery(const QString &query);
    void deletePlaylist(int row);

private:
    inline void setLoading(bool loading) { m_loading = loading; emit loadingChanged(loading); }

signals:
    void queryChanged(const QString &query);
    void countChanged(int count);
    void loadingChanged(bool loading);

private:
    PlaylistListModel *m_model;
    QString m_query;
    bool m_loading;
#if (defined (QML_USER_INTERFACE) && (!defined (Q_WS_MAEMO_5)))
    QString m_highlight;
#endif
};

#endif // ArchivePlaylistModel_H
