#ifndef ACTIVITYITEM_H
#define ACTIVITYITEM_H

#include "enums.h"
#include <QObject>
#include <QUrl>
#include <QVariantMap>

class ActivityItem : public QObject
{
    Q_OBJECT

    Q_PROPERTY(QString id
               READ id
               CONSTANT)
    Q_PROPERTY(Activities::ActivityType activityType
               READ activityType
               CONSTANT)
    Q_PROPERTY(QString activityTypeString
               READ activityTypeString
               CONSTANT)
    Q_PROPERTY(QString title
               READ title
               NOTIFY titleChanged)
    Q_PROPERTY(QString artist
               READ artist
               NOTIFY artistChanged)
    Q_PROPERTY(QString artistId
               READ artistId
               CONSTANT)
    Q_PROPERTY(QUrl artistAvatarUrl
               READ artistAvatarUrl
               NOTIFY artistAvatarUrlChanged)
    Q_PROPERTY(QString body
               READ body
               NOTIFY bodyChanged)
    Q_PROPERTY(QString date
               READ date
               NOTIFY dateChanged)
    Q_PROPERTY(QUrl thumbnailUrl
               READ thumbnailUrl
               NOTIFY thumbnailUrlChanged)

public:
    explicit ActivityItem(QObject *parent = 0);
    explicit ActivityItem(ActivityItem *activity, QObject *parent = 0);
    explicit ActivityItem(const QVariantMap &activity, QObject *parent = 0);
    ~ActivityItem() {}
    Q_INVOKABLE void loadActivity(ActivityItem *activity);
    inline QString id() const { return m_id; }
    inline void setId(const QString &id) { m_id = id; }
    inline Activities::ActivityType activityType() const { return m_type; }
    inline void setActivityType(Activities::ActivityType type) { m_type = type; }
    inline QString activityTypeString() const { return m_typeString; }
    inline void setActivityTypeString(const QString &type) { m_typeString = type; }
    inline QString title() const { return m_title; }
    inline void setTitle(const QString &title) { m_title = title; emit titleChanged(title); }
    inline QString artist() const { return m_artist; }
    inline void setArtist(const QString &artist) { m_artist = artist; emit artistChanged(artist); }
    inline QString artistId() const { return m_artistId; }
    inline void setArtistId(const QString &id) { m_artistId = id; }
    inline QUrl artistAvatarUrl() const { return m_artistAvatarUrl; }
    inline void setArtistAvatarUrl(const QUrl &url) { m_artistAvatarUrl = url; emit artistAvatarUrlChanged(url); }
    inline QString body() const { return m_body; }
    inline void setBody(const QString &body) { m_body = body; emit bodyChanged(body); }
    inline QString date() const { return m_date; }
    inline void setDate(const QString &date) { m_date = date; emit dateChanged(date); }
    inline QUrl thumbnailUrl() const { return m_thumbnailUrl; }
    inline void setThumbnailUrl(const QUrl &url) { m_thumbnailUrl = url; emit thumbnailUrlChanged(url); }

private:
    void loadTrack(const QVariantMap &track);
    void loadPlaylist(const QVariantMap &playlist);
    void loadTrackSharing(const QVariantMap &track);
    void loadComment(const QVariantMap &comment);
    void loadFavourite(const QVariantMap &favourite);
    
signals:
    void titleChanged(const QString &title);
    void artistChanged(const QString &artist);
    void artistAvatarUrlChanged(const QUrl &url);
    void bodyChanged(const QString &body);
    void dateChanged(const QString &date);
    void thumbnailUrlChanged(const QUrl &url);
    
private:
    QString m_id;
    Activities::ActivityType m_type;
    QString m_typeString;
    QString m_title;
    QString m_artist;
    QString m_artistId;
    QUrl m_artistAvatarUrl;
    QString m_body;
    QString m_date;
    QUrl m_thumbnailUrl;
};

#endif // ACTIVITYITEM_H
