from PyQt4.QtGui import QMainWindow, QHideEvent, QShowEvent, QMessageBox
from PyQt4.QtCore import Qt, QTimer, QObject, SIGNAL, pyqtSignature
from Ui_TestWindow import Ui_TestWindow
from Clef import Clefs
from Note import Note
from Staff import Staff
import time
import calendar
import random

class TestWindow(QMainWindow, Ui_TestWindow):

    def __init__(self, parent, settings, practiceMode=False):
        QMainWindow.__init__(self, parent)
        try:
            self.setAttribute(Qt.WA_Maemo5StackedWindow)
        except:
            pass
        self.timer=QTimer(self)
        QObject.connect(self.timer, SIGNAL("timeout()"), self.onTimerEvent)
        self.practiceMode = practiceMode

        self.numberOfNotes = 40
        self.currentNote = 1
        self.errors = 0

        clefs = []
        if(settings.useTrebleClef()):
            clefs.append(Clefs.TREBLE)
        if(settings.useBassClef()):
            clefs.append(Clefs.BASS)
        if(settings.useAltoClef()):
            clefs.append(Clefs.ALTO)

        self.notes = list()
        
        prevNote = None
        while len(self.notes) < self.numberOfNotes:
            clef = random.choice(clefs)
            noteRange = clef.getBeginnerRange()
            if(settings.getLevel() == "intermediate"):
                noteRange = clef.getIntermediateRange()
            if(settings.getLevel() == "advanced"):
                noteRange = clef.getAdvancedRange()
            note = Note(clef, random.choice(noteRange))
            if note != prevNote:
                self.notes.append(note)
                prevNote = note

    def event(self, event):
        if(isinstance(event, QShowEvent)):
            self.startTime=time.time()
            self.timer.start(100)
            self.updateNoteLabel()
            return False
        if(isinstance(event, QHideEvent)):
            self.timer.stop()
            return False
        return QMainWindow.event(self, event)

    def setupUi(self, mainwnd):
        super(TestWindow, self).setupUi(mainwnd)

        self.staff = Staff(self)
        self.graphicsView.setScene(self.staff)
        self.staff.showNote(self.notes[0])

    @pyqtSignature("")
    def onTimerEvent(self):
        self.timeLabel.setText(time.strftime("%M:%S", time.gmtime(time.time()-self.startTime)))
        self.timeLabel.update()

    @pyqtSignature("")
    def on_cButton_clicked(self):
        self.onReply("C")

    @pyqtSignature("")
    def on_dButton_clicked(self):
        self.onReply("D")

    @pyqtSignature("")
    def on_eButton_clicked(self):
        self.onReply("E")

    @pyqtSignature("")
    def on_fButton_clicked(self):
        self.onReply("F")

    @pyqtSignature("")
    def on_gButton_clicked(self):
        self.onReply("G")

    @pyqtSignature("")
    def on_aButton_clicked(self):
        self.onReply("A")

    @pyqtSignature("")
    def on_bButton_clicked(self):
        self.onReply("B")

    def onReply(self, note):
        if note == self.getCurrentNoteAsLetter():
            self.removeHighlights()
            self.currentNote = self.currentNote + 1
            if self.currentNote > self.numberOfNotes:
                self.timer.stop()
                self.disableButtons()
                
                delta = time.time() - self.startTime
                errorTime = self.errors * 3
                totalTime = delta + errorTime
                
                msg=QMessageBox(self)
                msg.setWindowTitle("Results")
                msg.setText("Execution time: %s\nErrors: %s x 3 = %s sec\nTotal time: %s" % (self.formatTime(delta), self.errors, errorTime, self.formatTime(totalTime)))
                msg.exec_()
                self.hide()
            else:
                self.staff.showNote(self.notes[self.currentNote - 1])
                self.updateNoteLabel()
        else:
            self.errors = self.errors + 1
            if self.practiceMode == True:
                self.highlightButton(self.getCurrentNoteAsLetter())

    def formatTime(self, t):
        part1 = time.strftime("%M:%S", time.gmtime(t))
        part2 = "%.3f" % (t - calendar.timegm(time.gmtime(t)))
        return "%s%s" % (part1, part2[1:])

    def getCurrentNoteAsLetter(self):
        note = self.notes[self.currentNote - 1]
        return note.asLetter()

    def updateNoteLabel(self):
        self.noteLabel.setText("%s / %s" % (self.currentNote, self.numberOfNotes))

    def disableButtons(self):
        self.cButton.setDisabled(True)
        self.dButton.setDisabled(True)
        self.eButton.setDisabled(True)
        self.fButton.setDisabled(True)
        self.gButton.setDisabled(True)
        self.aButton.setDisabled(True)
        self.bButton.setDisabled(True)

    def removeHighlights(self):
        self.cButton.setStyleSheet("")
        self.dButton.setStyleSheet("")
        self.eButton.setStyleSheet("")
        self.fButton.setStyleSheet("")
        self.gButton.setStyleSheet("")
        self.aButton.setStyleSheet("")
        self.bButton.setStyleSheet("")

    def highlightButton(self, note):
        style = "background: yellow; color: black; border-radius: 10px;"
        if note == "C":
            self.cButton.setStyleSheet(style)
        elif note == "D":
            self.dButton.setStyleSheet(style)
        elif note == "E":
            self.eButton.setStyleSheet(style)
        elif note == "F":
            self.fButton.setStyleSheet(style)
        elif note == "G":
            self.gButton.setStyleSheet(style)
        elif note == "A":
            self.aButton.setStyleSheet(style)
        elif note == "B":
            self.bButton.setStyleSheet(style)
