from PyQt4.QtCore import QSettings

class Settings():

    def __init__(self):
        self.__settings = QSettings("robyf.net", "musicsheettest") 
        self.__trebleClef = self.__settings.value("trebleClef", True).toBool()
        self.__bassClef = self.__settings.value("bassClef", True).toBool()
        self.__altoClef = self.__settings.value("altoClef", False).toBool()
        self.__level = self.__settings.value("level", "beginner").toString()

    def useTrebleClef(self):
        return self.__trebleClef

    def useBassClef(self):
        return self.__bassClef

    def useAltoClef(self):
        return self.__altoClef

    def getLevel(self):
        return self.__level

    def store(self, trebleClef, bassClef, altoClef, level):
        self.__trebleClef = trebleClef
        self.__bassClef = bassClef
        self.__altoClef = altoClef
        self.__level = level
        self.__settings.setValue("trebleClef", trebleClef)
        self.__settings.setValue("bassClef", bassClef)
        self.__settings.setValue("altoClef", altoClef)
        self.__settings.setValue("level", level)
        self.__settings.sync()

