#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QtXml>
#include <QTextBlock>
#include <QFileDialog>
#include <QMovie>
#include <Phonon>
#include <VolumeSlider>

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT
public:
    enum ScreenOrientation {
        ScreenOrientationLockPortrait,
        ScreenOrientationLockLandscape,
        ScreenOrientationAuto
    };

    explicit MainWindow(QWidget *parent = 0);
    virtual ~MainWindow();
    void setOrientation(ScreenOrientation orientation);
    void showExpanded();

private slots:
    void on_btnSearch_clicked();
    void on_btnDownload_clicked();
    void download(QString item);
    void stream(QString item);
    void downloadFinished(QNetworkReply *reply);
    void streamFinished(QNetworkReply *reply);

    void on_actionAbout_triggered();

    void on_btnPlay_clicked();

    void on_btnStop_clicked();

private:
    Ui::MainWindow *ui;
    QNetworkAccessManager *netAccessMan;
    QNetworkAccessManager *netAccessManStream;
    QByteArray downloadedItem;
    QStringList *links;
    QMovie *movie;
    Phonon::MediaObject *music;
};

#endif // MAINWINDOW_H
